/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.exceptionlog;

import com.sinosoft.sysframework.common.datatype.DateTime;
import com.sinosoft.sysframework.common.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UserException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int errorCatalog = 0;
    private int errorNo = 0;
    private String errorMessage = "";
    private String errorModule = "Unknow Module";
    private String errorAppend = "";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Map userExceptionMap = new HashMap();
    private static final String DELIMITER = "^";
    private static boolean init = false;
    private static final File CONFIG_FILE = FileUtils.getUniqueFile(class$com$sinosoft$sysframework$exceptionlog$UserException == null ? (class$com$sinosoft$sysframework$exceptionlog$UserException = UserException.class$("com.sinosoft.sysframework.exceptionlog.UserException")) : class$com$sinosoft$sysframework$exceptionlog$UserException, ".config");
    private static long lastModified = 0L;
    private static File localConfigFile;
    private static Log logger;
    static /* synthetic */ Class class$com$sinosoft$sysframework$exceptionlog$UserException;

    public UserException(int theErrorCatalog, int theErrorNo, String theErrorModule) {
        this.errorCatalog = theErrorCatalog;
        this.errorNo = theErrorNo;
        this.errorModule = theErrorModule;
        try {
            this.setErrorMessageFromErrorCode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UserException(int theErrorCatalog, int theErrorNo, String theErrorModule, String theErrorMessage, String theErrorAppend) {
        this.errorCatalog = theErrorCatalog;
        this.errorNo = theErrorNo;
        this.errorModule = theErrorModule;
        this.errorMessage = theErrorMessage;
        this.errorAppend = theErrorAppend;
    }

    public UserException(int theErrorCatalog, int theErrorNo, String theErrorModule, String theErrorMessage) {
        this.errorCatalog = theErrorCatalog;
        this.errorNo = theErrorNo;
        this.errorModule = theErrorModule;
        this.errorMessage = theErrorMessage;
    }

    public static synchronized void configure(String fileName) throws Exception {
        if (!init) {
            UserException.reconfigure(fileName);
        }
    }

    public static synchronized void reconfigure(String fileName) throws Exception {
        try {
            localConfigFile = new File(fileName);
            lastModified = localConfigFile.lastModified();
            FileUtils.write(fileName, CONFIG_FILE);
            UserException.configure(new BufferedInputStream(new FileInputStream(fileName)));
            logger.info((Object)("Success load UserException configuration at \"" + fileName + "\"."));
            init = true;
        }
        catch (Exception e) {
            logger.info((Object)("Fail load UserException configuration at \"" + fileName + "\"."), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void configure(InputStream inputStream) throws Exception {
        Class clazz = class$com$sinosoft$sysframework$exceptionlog$UserException == null ? (class$com$sinosoft$sysframework$exceptionlog$UserException = UserException.class$("com.sinosoft.sysframework.exceptionlog.UserException")) : class$com$sinosoft$sysframework$exceptionlog$UserException;
        synchronized (clazz) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            NodeList userExceptions = document.getElementsByTagName("UserException");
            int n = userExceptions.getLength();
            for (int i = 0; i < n; ++i) {
                if (userExceptions.item(i).getNodeType() != 1) continue;
                String errorCatalog = userExceptions.item(i).getAttributes().getNamedItem("ErrorCatalog").getNodeValue();
                String errorNo = "";
                String errorMessage = "";
                NodeList errors = userExceptions.item(i).getChildNodes();
                int errorLength = errors.getLength();
                for (int j = 0; j < errorLength; ++j) {
                    if (errors.item(j).getNodeType() != 1) continue;
                    Element element = (Element)errors.item(j);
                    errorNo = element.getElementsByTagName("ErrorNo").item(0).getFirstChild().getNodeValue();
                    errorMessage = element.getElementsByTagName("ErrorMessage").item(0).getFirstChild().getNodeValue();
                    userExceptionMap.put(errorCatalog + DELIMITER + errorNo, errorMessage);
                }
            }
            inputStream.close();
        }
    }

    public int getErrorCatalog() {
        return this.errorCatalog;
    }

    public int getErrorNo() {
        return this.errorNo;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorModule() {
        return this.errorModule;
    }

    private void setErrorMessageFromErrorCode() throws Exception {
        if (!init) {
            String fileName;
            if (!CONFIG_FILE.exists()) {
                try {
                    if (!CONFIG_FILE.createNewFile()) {
                        logger.info((Object)("Create file " + CONFIG_FILE.getAbsolutePath() + " fail."));
                    }
                }
                catch (IOException e) {
                    logger.info((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (CONFIG_FILE.exists() && new File(fileName = FileUtils.read(CONFIG_FILE)).exists()) {
                UserException.reconfigure(fileName);
            }
        } else if (lastModified < localConfigFile.lastModified()) {
            UserException.reconfigure(localConfigFile.getAbsolutePath());
        }
        this.errorMessage = (String)userExceptionMap.get(this.errorCatalog + DELIMITER + this.errorNo);
        if (this.errorMessage == null) {
            this.errorMessage = "Unkown Message";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            DateTime now = new DateTime(new Date(), 16);
            StringBuffer buffer = new StringBuffer(300);
            buffer.append(LINE_SEPARATOR).append("***** UserException occurred at ").append(now).append(" *****");
            buffer.append(LINE_SEPARATOR).append("ErrorCatalog = ").append(this.getErrorCatalog());
            buffer.append(LINE_SEPARATOR).append("ErrorNo      = ").append(this.getErrorNo());
            buffer.append(LINE_SEPARATOR).append("ErrorModule  = ").append(this.getErrorModule());
            buffer.append(LINE_SEPARATOR).append("ErrorMessage = ").append(this.getErrorMessage());
            buffer.append(LINE_SEPARATOR);
            buffer.append(LINE_SEPARATOR).append("The stack trace is: ");
            buffer.append(LINE_SEPARATOR).append(this.errorAppend);
            buffer.append(LINE_SEPARATOR);
            s.print(buffer.toString());
            super.printStackTrace(s);
        }
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public static boolean isInit() {
        return init;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = LogFactory.getLog((Class)(class$com$sinosoft$sysframework$exceptionlog$UserException == null ? (class$com$sinosoft$sysframework$exceptionlog$UserException = UserException.class$("com.sinosoft.sysframework.exceptionlog.UserException")) : class$com$sinosoft$sysframework$exceptionlog$UserException));
    }
}

