/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.mail;

import com.sinosoft.sysframework.mail.Mail;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class PostOffice {
    private Session session;
    private Properties props;

    public PostOffice(String smtp, String user, String password) {
        if (this.props == null) {
            this.props = System.getProperties();
        }
        this.props.put("mail.smtp.host", smtp);
        this.props.put("mail.smtp.user", user);
        this.props.put("mail.smtp.password", password);
        if ((user == null || user.trim().equals("")) && (password == null || password.trim().equals(""))) {
            this.props.put("mail.smtp.auth", "false");
        } else {
            this.props.put("mail.smtp.auth", "true");
        }
        this.session = Session.getDefaultInstance((Properties)this.props, null);
    }

    private void setReplyTo(MimeMessage mimeMsg, Mail mail) throws AddressException, MessagingException {
        InternetAddress[] replyTos = new InternetAddress[mail.getToList().size()];
        int index = 0;
        Iterator iter = mail.getToList().iterator();
        while (iter.hasNext()) {
            String replyTo = (String)iter.next();
            replyTos[index++] = new InternetAddress(replyTo);
        }
        mimeMsg.setReplyTo((Address[])replyTos);
    }

    private void setRecipients(MimeMessage mimeMsg, Mail mail) throws AddressException, MessagingException {
        String recipient;
        Iterator iter = mail.getToList().iterator();
        while (iter.hasNext()) {
            recipient = (String)iter.next();
            mimeMsg.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipient));
        }
        iter = mail.getCcList().iterator();
        while (iter.hasNext()) {
            recipient = (String)iter.next();
            mimeMsg.addRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)recipient));
        }
        iter = mail.getBccList().iterator();
        while (iter.hasNext()) {
            recipient = (String)iter.next();
            mimeMsg.addRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)recipient));
        }
    }

    public synchronized void send(Mail mail) throws Exception {
        this.send(new Mail[]{mail});
    }

    public synchronized void send(Mail[] mails) throws Exception {
        Transport transport = this.session.getTransport("smtp");
        transport.connect((String)this.props.get("mail.smtp.host"), (String)this.props.get("mail.smtp.user"), (String)this.props.get("mail.smtp.password"));
        for (int i = 0; i < mails.length; ++i) {
            Mail mail = mails[i];
            MimeMessage mimeMsg = new MimeMessage(this.session);
            MimeMultipart mp = new MimeMultipart();
            mimeMsg.setContent((Multipart)mp);
            mimeMsg.setFrom((Address)new InternetAddress(mail.getFromAddress(), mail.getFromName()));
            this.setReplyTo(mimeMsg, mail);
            mimeMsg.setSubject(mail.getSubject());
            MimeBodyPart bp = new MimeBodyPart();
            bp.setContent((Object)mail.getContent(), "text/html;charset=gb2312");
            mp.addBodyPart((BodyPart)bp);
            Iterator iter = mail.getAttachmentList().iterator();
            while (iter.hasNext()) {
                String attachment = (String)iter.next();
                bp = new MimeBodyPart();
                FileDataSource fileds = new FileDataSource(attachment);
                bp.setDataHandler(new DataHandler((DataSource)fileds));
                bp.setFileName(MimeUtility.encodeText((String)fileds.getName()));
                mp.addBodyPart((BodyPart)bp);
            }
            this.setRecipients(mimeMsg, mail);
            mimeMsg.setSentDate(new Date());
            mimeMsg.saveChanges();
            transport.sendMessage((Message)mimeMsg, mimeMsg.getAllRecipients());
        }
        transport.close();
    }
}

