/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.persistence;

import com.sinosoft.sysframework.common.util.DataUtils;
import com.sinosoft.sysframework.exception.ExceptionCause;
import com.sinosoft.sysframework.exception.PersistenceException;
import com.sinosoft.sysframework.persistence.HibernateQuery;
import com.sinosoft.sysframework.persistence.HibernateSQLQuery;
import com.sinosoft.sysframework.persistence.HibernateSQLUpdate;
import com.sinosoft.sysframework.reference.AppConfig;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.support.DaoSupport;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateOperations;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.util.Assert;

public class BaseDaoHibernateImpl
extends DaoSupport {
    private HibernateOperations hibernateTemplate;
    private JdbcTemplate jdbcTemplate;

    public final void setSessionFactory(SessionFactory sessionFactory) {
        this.hibernateTemplate = this.createHibernateTemplate(sessionFactory);
    }

    protected HibernateTemplate createHibernateTemplate(SessionFactory sessionFactory) {
        return new HibernateTemplate(sessionFactory);
    }

    public final SessionFactory getSessionFactory() {
        return this.hibernateTemplate != null ? ((HibernateTemplate)this.hibernateTemplate).getSessionFactory() : null;
    }

    public void setHibernateTemplate(HibernateOperations hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public HibernateOperations getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    protected final void checkDaoConfig() {
        if (this.hibernateTemplate == null) {
            throw new IllegalArgumentException("sessionFactory or hibernateTemplate is required");
        }
    }

    protected final Session getSession() throws DataAccessResourceFailureException, IllegalStateException {
        return this.getSession(((HibernateTemplate)this.hibernateTemplate).isAllowCreate());
    }

    protected final Session getSession(boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return !allowCreate ? SessionFactoryUtils.getSession((SessionFactory)this.getSessionFactory(), (boolean)false) : SessionFactoryUtils.getSession((SessionFactory)this.getSessionFactory(), (Interceptor)((HibernateTemplate)this.hibernateTemplate).getEntityInterceptor(), (SQLExceptionTranslator)((HibernateTemplate)this.hibernateTemplate).getJdbcExceptionTranslator());
    }

    protected final DataAccessException convertHibernateAccessException(HibernateException ex) {
        return ((HibernateTemplate)this.hibernateTemplate).convertHibernateAccessException(ex);
    }

    protected final void releaseSession(Session session) {
        SessionFactoryUtils.releaseSession((Session)session, (SessionFactory)this.getSessionFactory());
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    protected List queryList(HibernateQuery hq) {
        ArrayList list = this.getHibernateTemplate().executeFind((HibernateCallback)hq);
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    protected List queryList(HibernateSQLQuery hsq) {
        ArrayList list = this.getHibernateTemplate().executeFind((HibernateCallback)hsq);
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    protected Object queryUniqueObject(HibernateQuery hq) {
        List list = this.getHibernateTemplate().executeFind((HibernateCallback)hq);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    protected Object queryUniqueObject(HibernateSQLQuery hsq) {
        List list = this.getHibernateTemplate().executeFind((HibernateCallback)hsq);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    protected Integer queryIntegerResult(HibernateQuery hq) {
        List list = this.getHibernateTemplate().executeFind((HibernateCallback)hq);
        if (list == null || list.size() == 0) {
            return null;
        }
        return DataUtils.getInteger(list.get(0));
    }

    protected Integer queryIntegerResult(HibernateSQLQuery hsq) {
        List list = this.getHibernateTemplate().executeFind((HibernateCallback)hsq);
        if (list == null || list.size() == 0) {
            return null;
        }
        return DataUtils.getInteger(list.get(0));
    }

    protected int executeUpdate(HibernateSQLUpdate hsu) {
        Object object = this.getHibernateTemplate().execute((HibernateCallback)hsu);
        return DataUtils.getInteger(object);
    }

    protected void checkTotalCount(int totalCount, String sysConstConfigName) {
        if (sysConstConfigName == null) {
            return;
        }
        String configValue = AppConfig.get(sysConstConfigName);
        if (configValue == null || configValue.length() == 0) {
            return;
        }
        if (totalCount > Integer.parseInt(configValue)) {
            ExceptionCause cause = new ExceptionCause();
            cause.setMessageKey("errors.content.queryresult.maxlimit");
            cause.setMessageArgs(new String[]{configValue});
            cause.setResource(true);
            PersistenceException pe = new PersistenceException();
            pe.addCause(cause);
            throw pe;
        }
    }

    public List findByHql(String hql, final Object[] values) {
        Assert.hasText((String)hql);
        String newHql = hql;
        int pos = 0;
        if (values != null) {
            for (int i = 0; i < values.length && (pos = newHql.indexOf(63, pos)) != -1; ++i) {
                if (values[i] instanceof Collection && pos > -1) {
                    newHql = newHql.substring(0, pos) + ":queryParam" + i + newHql.substring(pos + 1);
                }
                ++pos;
            }
        }
        final String fnHql = newHql;
        List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                Query query = session.createQuery(fnHql);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList("queryParam" + i, (Collection)values[i]);
                            continue;
                        }
                        query.setParameter(i, values[i]);
                    }
                }
                return query.list();
            }
        });
        return list;
    }

    protected static String removeSelect(String hql) {
        Assert.hasText((String)hql);
        int beginPos = hql.toLowerCase().indexOf("from");
        Assert.isTrue((beginPos != -1 ? 1 : 0) != 0, (String)(" hql : " + hql + " must has a keyword 'from'"));
        return hql.substring(beginPos);
    }

    protected static String removeOrders(String hql) {
        Assert.hasText((String)hql);
        Pattern p = Pattern.compile("order\\s*by[\\w|\\W|\\s|\\S]*", 2);
        Matcher m = p.matcher(hql);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

