/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.persistence;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class DataSourceManager {
    static /* synthetic */ Class class$com$sinosoft$sysframework$persistence$DataSourceManager;

    private static Properties loadJdbcProperties(String fileName) throws IOException {
        Properties p = new Properties();
        InputStream is = (class$com$sinosoft$sysframework$persistence$DataSourceManager == null ? (class$com$sinosoft$sysframework$persistence$DataSourceManager = DataSourceManager.class$("com.sinosoft.sysframework.persistence.DataSourceManager")) : class$com$sinosoft$sysframework$persistence$DataSourceManager).getResourceAsStream("/" + fileName);
        if (is == null) {
            throw new FileNotFoundException("Can't find " + fileName + " in classpath.");
        }
        p.load(is);
        String[] requiredProperties = new String[]{"jdbc.url", "jdbc.driverClassName", "jdbc.username", "jdbc.password", "jndi.name"};
        for (int i = 0; i < requiredProperties.length; ++i) {
            if (DataSourceManager.isPropertyExist(p, requiredProperties[i])) continue;
            System.err.println("Can't find property " + requiredProperties[i] + " in file " + fileName);
        }
        return p;
    }

    private static boolean isPropertyExist(Properties p, String key) {
        String value = p.getProperty(key);
        return value != null && value.trim().length() != 0;
    }

    public static void initDataSource(String fileName) throws Exception {
        Properties p = DataSourceManager.loadJdbcProperties(fileName);
        System.setProperty("java.naming.factory.initial", "com.sun.jndi.fscontext.RefFSContextFactory");
        InitialContext ic = new InitialContext();
        Reference cpdsRef = new Reference("org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS", "org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS", null);
        cpdsRef.add(new StringRefAddr("driver", p.getProperty("jdbc.driverClassName")));
        cpdsRef.add(new StringRefAddr("url", p.getProperty("jdbc.url")));
        cpdsRef.add(new StringRefAddr("user", p.getProperty("jdbc.username")));
        cpdsRef.add(new StringRefAddr("password", p.getProperty("jdbc.password")));
        ic.rebind("jdbc/cpds", (Object)cpdsRef);
        Reference ref = new Reference("org.apache.commons.dbcp.datasources.PerUserPoolDataSource", "org.apache.commons.dbcp.datasources.PerUserPoolDataSourceFactory", null);
        ref.add(new StringRefAddr("dataSourceName", "jdbc/cpds"));
        if (DataSourceManager.isPropertyExist(p, "jdbc.maxActive")) {
            ref.add(new StringRefAddr("defaultMaxActive", p.getProperty("jdbc.maxActive")));
        }
        if (DataSourceManager.isPropertyExist(p, "jdbc.maxIdle")) {
            ref.add(new StringRefAddr("defaultMaxIdle", p.getProperty("jdbc.maxIdle")));
        }
        if (DataSourceManager.isPropertyExist(p, "jdbc.maxWait")) {
            ref.add(new StringRefAddr("defaultMaxWait", p.getProperty("jdbc.maxWait")));
        }
        ic.rebind(p.getProperty("jndi.name"), (Object)ref);
        DataSource ds = (DataSource)ic.lookup(p.getProperty("jndi.name"));
        Connection conn = ds.getConnection();
        conn.close();
        System.out.println("Bind datasource \"" + p.getProperty("jndi.name") + "\" success.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

