/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.reference;

import com.sinosoft.sysframework.common.util.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AppConfig {
    private static Map configMap = Collections.synchronizedMap(new TreeMap());
    private Vector configNameTrace = null;
    private static boolean init = false;
    private static final File CONFIG_FILE = FileUtils.getUniqueFile(class$com$sinosoft$sysframework$reference$AppConfig == null ? (class$com$sinosoft$sysframework$reference$AppConfig = AppConfig.class$("com.sinosoft.sysframework.reference.AppConfig")) : class$com$sinosoft$sysframework$reference$AppConfig, ".config");
    private static long lastModified = 0L;
    private static int configFileCount = 0;
    private static File localConfigFile;
    private static Log logger;
    static /* synthetic */ Class class$com$sinosoft$sysframework$reference$AppConfig;

    public static synchronized void configure(String confPath) throws Exception {
        if (!init) {
            AppConfig.reconfigure(confPath);
        }
    }

    public static synchronized void reconfigure(String confPath) throws Exception {
        FileUtils.write(confPath, CONFIG_FILE);
        configMap.clear();
        File[] confFiles = null;
        File conf = new File(confPath);
        if (!conf.exists()) {
            return;
        }
        confFiles = conf.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        });
        configFileCount = confFiles.length;
        if (configFileCount == 1) {
            localConfigFile = confFiles[0];
            lastModified = localConfigFile.lastModified();
        }
        AppConfig appConfig = new AppConfig();
        for (int i = 0; i < confFiles.length; ++i) {
            try {
                appConfig.iniAppConfig(confFiles[i]);
                logger.info((Object)("Success load Application configuration at \"" + confFiles[i].getPath() + "\"."));
                init = true;
                continue;
            }
            catch (Exception e) {
                logger.info((Object)("Fail load Application configuration at \"" + confFiles[i].getPath() + "\"."), (Throwable)e);
                throw e;
            }
        }
        init = true;
    }

    private void iniAppConfig(File appConfigFile) throws Exception {
        this.configNameTrace = new Vector();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(appConfigFile);
        Element rootNode = document.getDocumentElement();
        this.parseNode(rootNode);
    }

    private void parseNode(Node node) throws Exception {
        this.configNameTrace.add(node.getNodeName());
        NodeList childNodes = node.getChildNodes();
        Node childNode = null;
        Node textNode = null;
        String configName = "";
        String configValue = "";
        for (int i = 0; i < childNodes.getLength(); ++i) {
            childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            textNode = childNode.getChildNodes().item(0);
            if (childNode.getChildNodes().getLength() == 1 && textNode.getNodeType() == 3) {
                configName = "";
                configValue = "";
                configName = this.getConfigName() + childNode.getNodeName();
                configValue = textNode.getNodeValue().trim();
                configMap.put(configName, configValue);
                continue;
            }
            this.parseNode(childNode);
            this.configNameTrace.remove(this.configNameTrace.size() - 1);
        }
    }

    private String getConfigName() {
        String configName = "";
        for (int i = 0; i < this.configNameTrace.size(); ++i) {
            configName = configName + (String)this.configNameTrace.get(i) + ".";
        }
        return configName;
    }

    public static String get(String configName) {
        try {
            if (!init) {
                String confPath;
                if (!CONFIG_FILE.exists() && !CONFIG_FILE.createNewFile()) {
                    logger.info((Object)("Create file " + CONFIG_FILE.getAbsolutePath() + " fail."));
                }
                if (CONFIG_FILE.exists() && new File(confPath = FileUtils.read(CONFIG_FILE)).exists()) {
                    AppConfig.configure(confPath);
                }
            } else if (configFileCount == 1 && lastModified < localConfigFile.lastModified()) {
                AppConfig.reconfigure(localConfigFile.getParentFile().getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String configValue = "";
        try {
            configValue = (String)configMap.get(configName);
        }
        catch (Throwable e) {
            logger.info((Object)("Can't get " + configName + ".Current cache size is " + configMap.size() + ",init = " + init), e);
            throw new IllegalArgumentException("Can't find " + configName);
        }
        return configValue;
    }

    public static boolean isInit() {
        return init;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = LogFactory.getLog((Class)(class$com$sinosoft$sysframework$reference$AppConfig == null ? (class$com$sinosoft$sysframework$reference$AppConfig = AppConfig.class$("com.sinosoft.sysframework.reference.AppConfig")) : class$com$sinosoft$sysframework$reference$AppConfig));
        logger.info((Object)"The first time load AppConfig.");
    }
}

