/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.reference;

import com.sinosoft.sysframework.common.util.FileUtils;
import com.sinosoft.sysframework.reference.DBDataSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DBFactory {
    private static Map map = Collections.synchronizedMap(new HashMap());
    private static boolean init = false;
    private static final File CONFIG_FILE = FileUtils.getUniqueFile(class$com$sinosoft$sysframework$reference$DBFactory == null ? (class$com$sinosoft$sysframework$reference$DBFactory = DBFactory.class$("com.sinosoft.sysframework.reference.DBFactory")) : class$com$sinosoft$sysframework$reference$DBFactory, ".config");
    private static long lastModified = 0L;
    private static File localConfigFile;
    private static Log logger;
    static /* synthetic */ Class class$com$sinosoft$sysframework$reference$DBFactory;

    public static synchronized void configure(String fileName) throws Exception {
        if (!init) {
            DBFactory.reconfigure(fileName);
        }
    }

    public static synchronized void reconfigure(String fileName) throws Exception {
        try {
            localConfigFile = new File(fileName);
            lastModified = localConfigFile.lastModified();
            FileUtils.write(fileName, CONFIG_FILE);
            DBFactory.configure(new FileInputStream(fileName));
            logger.info((Object)("Success load DBManager configuration at \"" + fileName + "\"."));
            init = true;
        }
        catch (Exception e) {
            logger.info((Object)("Fail load DBManager configuration at \"" + fileName + "\"."), (Throwable)e);
            throw e;
        }
    }

    private static synchronized void configure(InputStream inputStream) throws Exception {
        BufferedInputStream is = new BufferedInputStream(inputStream);
        map.clear();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(is);
        is.close();
        NodeList datasourceDefines = document.getElementsByTagName("datasource-define");
        for (int i = 0; i < datasourceDefines.getLength(); ++i) {
            if (datasourceDefines.item(i).getNodeType() != 1) continue;
            String name = DBFactory.getChildNodeValue(datasourceDefines.item(i), "name");
            String jndiname = DBFactory.getChildNodeValue(datasourceDefines.item(i), "jndiname");
            String dbToServerEncodeCharset = DBFactory.getChildNodeValue(datasourceDefines.item(i), "db-to-server-encode-charset");
            String dbToServerDecodeCharset = DBFactory.getChildNodeValue(datasourceDefines.item(i), "db-to-server-decode-charset");
            boolean needConvertFromDbToServer = Boolean.valueOf(DBFactory.getChildNodeValue(datasourceDefines.item(i), "need-convert-from-db-to-server"));
            String serverToDbEncodeCharset = DBFactory.getChildNodeValue(datasourceDefines.item(i), "server-to-db-encode-charset");
            String serverToDbDecodeCharset = DBFactory.getChildNodeValue(datasourceDefines.item(i), "server-to-db-decode-charset");
            boolean needConvertFromServerToDb = Boolean.valueOf(DBFactory.getChildNodeValue(datasourceDefines.item(i), "need-convert-from-server-to-db"));
            DBDataSource dbDataSource = new DBDataSource(name, jndiname, dbToServerEncodeCharset, dbToServerDecodeCharset, needConvertFromDbToServer, serverToDbEncodeCharset, serverToDbDecodeCharset, needConvertFromServerToDb);
            map.put(name, dbDataSource);
        }
    }

    private DBFactory() {
    }

    public static void registDB(DBDataSource dbDataSource) {
        map.put(dbDataSource.getName(), dbDataSource);
    }

    public static void removeDB(String name) {
        map.remove(name);
    }

    public static DBDataSource getDB(String name) {
        block10: {
            try {
                if (!init) {
                    String fileName;
                    if (!CONFIG_FILE.exists()) {
                        try {
                            if (!CONFIG_FILE.createNewFile()) {
                                logger.info((Object)("Create file " + CONFIG_FILE.getAbsolutePath() + " fail."));
                            }
                        }
                        catch (IOException e) {
                            logger.info((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    if (CONFIG_FILE.exists() && new File(fileName = FileUtils.read(CONFIG_FILE)).exists()) {
                        DBFactory.reconfigure(fileName);
                    }
                    break block10;
                }
                if (lastModified < localConfigFile.lastModified()) {
                    DBFactory.reconfigure(localConfigFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (!map.containsKey(name)) {
            logger.info((Object)("**** DBDataSource " + name + " has not registed!"));
            throw new IllegalArgumentException("**** DBDataSource " + name + " has not registed!");
        }
        return (DBDataSource)map.get(name);
    }

    public static void clear() {
        map.clear();
    }

    private static String getChildNodeValue(Node currentNode, String tagName) {
        String value = "";
        NodeList nodeList = currentNode.getChildNodes();
        Node node = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (!node.getNodeName().equals(tagName)) continue;
            if (node.getFirstChild() == null) break;
            value = node.getFirstChild().getNodeValue();
            value = value == null ? "" : value.trim();
            break;
        }
        return value;
    }

    public static boolean isInit() {
        return init;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = LogFactory.getLog((Class)(class$com$sinosoft$sysframework$reference$DBFactory == null ? (class$com$sinosoft$sysframework$reference$DBFactory = DBFactory.class$("com.sinosoft.sysframework.reference.DBFactory")) : class$com$sinosoft$sysframework$reference$DBFactory));
    }
}

