/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.reference;

import com.sinosoft.sysframework.common.datatype.DateTime;
import com.sinosoft.sysframework.common.util.DataUtils;
import com.sinosoft.sysframework.common.util.ExceptionUtils;
import com.sinosoft.sysframework.common.util.SqlUtils;
import com.sinosoft.sysframework.common.util.StringUtils;
import com.sinosoft.sysframework.reference.AppConfig;
import com.sinosoft.sysframework.reference.DBDataSource;
import com.sinosoft.sysframework.reference.DBFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBManager {
    private Statement statement = null;
    private Connection connection = null;
    private ResultSet resultSet = null;
    private PreparedStatement preparedStatement = null;
    private DBDataSource dbDataSource = null;
    private static HashMap dataSources = new HashMap();
    private static HashMap tableColumns = new HashMap();
    private boolean useTrim = true;
    private int resultSetType = 1004;
    private int resultSetConcurrency = 1008;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static Map connectionMap = Collections.synchronizedMap(new TreeMap());
    private static Map sqlMap = Collections.synchronizedMap(new TreeMap());
    private static int lastId = 0;
    private String currentKey = "";
    private List sqlList = new ArrayList();
    private static Hashtable contextProps = new Hashtable();

    public static Hashtable getContextProps() {
        return contextProps;
    }

    public static void initContextProps() {
        contextProps.clear();
        String value = AppConfig.get("sysconst.INITIAL_CONTEXT_FACTORY");
        if (value != null && value.length() > 0) {
            contextProps.put("java.naming.factory.initial", value);
        }
        if ((value = AppConfig.get("sysconst.PROVIDER_URL")) != null && value.length() > 0) {
            contextProps.put("java.naming.provider.url", value);
        }
        if ((value = AppConfig.get("sysconst.SECURITY_PRINCIPAL")) != null && value.length() > 0) {
            contextProps.put("java.naming.security.principal", value);
        }
        if ((value = AppConfig.get("sysconst.SECURITY_CREDENTIALS")) != null && value.length() > 0) {
            contextProps.put("java.naming.security.credentials", value);
        }
    }

    public DataSource getDataSource(String name) throws NamingException {
        DataSource dataSource;
        Object object = dataSources.get(name);
        if (object != null) {
            return (DataSource)object;
        }
        InitialContext context = new InitialContext(contextProps);
        DBDataSource dbDataSource = DBFactory.getDB(name);
        try {
            dataSource = (DataSource)context.lookup(dbDataSource.getJndiName());
        }
        catch (NamingException e) {
            dataSource = (DataSource)context.lookup("java:comp/env/" + dbDataSource.getJndiName());
        }
        dataSources.put(name, dataSource);
        return dataSource;
    }

    public void open(String name) throws Exception {
        DataSource dataSource = this.getDataSource(name);
        this.open(name, dataSource.getConnection());
    }

    public void open(String name, Connection connection) throws Exception {
        this.dbDataSource = DBFactory.getDB(name);
        this.open(this.dbDataSource, connection);
    }

    public void open(DBDataSource dbDataSource, Connection connection) throws Exception {
        this.dbDataSource = dbDataSource;
        if (this.connection != null) {
            this.logger.warn((Object)DBManager.getStackTrace("\u8fde\u63a5\u91cd\u590d\u6253\u5f00\uff0c\u53ef\u80fd\u5bfc\u81f4\u8fde\u63a5\u6c60\u6cc4\u9732"));
        }
        this.connection = connection;
        if (this.logger.isDebugEnabled()) {
            this.currentKey = "" + lastId++;
            connectionMap.put(this.currentKey, this.connection);
            sqlMap.put(this.currentKey, this.sqlList);
            this.sqlList.add(new Date() + DBManager.getStackTrace("\u6253\u5f00\u8fde\u63a5(key=" + this.currentKey + ")"));
        }
        try {
            this.statement = this.connection.createStatement(this.resultSetType, this.resultSetConcurrency);
        }
        catch (SQLException e) {
            this.connection.close();
            throw e;
        }
    }

    public void close() throws Exception {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.resultSet = null;
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.statement = null;
        }
        if (this.preparedStatement != null) {
            try {
                this.preparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.preparedStatement = null;
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        connectionMap.remove(this.currentKey);
        sqlMap.remove(this.currentKey);
    }

    public void beginTransaction() throws Exception {
        if (this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(false);
        }
    }

    public void commitTransaction() throws Exception {
        if (this.connection != null) {
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
    }

    public void rollbackTransaction() throws Exception {
        if (this.connection != null) {
            this.connection.rollback();
            this.connection.setAutoCommit(true);
        }
    }

    public void prepareStatement(String statement) throws Exception {
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
        }
        this.logSQL(statement);
        this.preparedStatement = this.connection.prepareStatement(statement, this.resultSetType, this.resultSetConcurrency);
    }

    public void prepareStatement(String statement, Object[] values) throws Exception {
        this.prepareStatement(statement);
        if (values != null || values.length > 0) {
            this.injectParamValues(values);
        }
    }

    public void addBatch() throws Exception {
        this.preparedStatement.addBatch();
    }

    public int[] executePreparedUpdateBatch() throws Exception {
        return this.preparedStatement.executeBatch();
    }

    public void setString(int index, String value) throws Exception {
        value = DataUtils.nullToEmpty(value);
        if (!(!this.dbDataSource.isNeedConvertFromServerToDb() || this.dbDataSource.getServerToDbDecodeCharset().equals("") && this.dbDataSource.getServerToDbEncodeCharset().equals(""))) {
            value = this.dbDataSource.getServerToDbDecodeCharset().equals("") ? new String(value.getBytes(), this.dbDataSource.getServerToDbEncodeCharset()) : (this.dbDataSource.getServerToDbEncodeCharset().equals("") ? new String(value.getBytes(this.dbDataSource.getServerToDbDecodeCharset())) : new String(value.getBytes(this.dbDataSource.getServerToDbDecodeCharset()), this.dbDataSource.getServerToDbEncodeCharset()));
        }
        if (this.useTrim) {
            value = StringUtils.rightTrim(value);
        }
        this.preparedStatement.setString(index, value);
    }

    public void setInt(int index, int value) throws Exception {
        this.preparedStatement.setInt(index, value);
    }

    public void setLong(int index, long value) throws Exception {
        this.preparedStatement.setLong(index, value);
    }

    public void setDouble(int index, double value) throws Exception {
        this.preparedStatement.setDouble(index, value);
    }

    public void setDateTime(int index, DateTime value) throws Exception {
        if (value != null) {
            if (value.isEmpty()) {
                this.preparedStatement.setNull(index, 93);
            } else {
                Timestamp time = new Timestamp(value.getTime());
                this.preparedStatement.setTimestamp(index, time);
            }
        }
    }

    public void setBytes(int index, byte[] value) throws Exception {
        this.preparedStatement.setBytes(index, value);
    }

    public String getString(ResultSet resultSet, int index) throws Exception {
        String value = resultSet.getString(index);
        value = DataUtils.dbNullToEmpty(value);
        if (!(!this.dbDataSource.isNeedConvertFromDbToServer() || this.dbDataSource.getDbToServerDecodeCharset().equals("") && this.dbDataSource.getDbToServerEncodeCharset().equals(""))) {
            value = this.dbDataSource.getDbToServerDecodeCharset().equals("") ? new String(value.getBytes(), this.dbDataSource.getDbToServerEncodeCharset()) : (this.dbDataSource.getDbToServerEncodeCharset().equals("") ? new String(value.getBytes(this.dbDataSource.getDbToServerDecodeCharset())) : new String(value.getBytes(this.dbDataSource.getDbToServerDecodeCharset()), this.dbDataSource.getDbToServerEncodeCharset()));
        }
        if (this.useTrim) {
            value = StringUtils.rightTrim(value);
        }
        return value;
    }

    public int getInt(ResultSet resultSet, int index) throws Exception {
        return resultSet.getInt(index);
    }

    public long getLong(ResultSet resultSet, int index) throws Exception {
        return resultSet.getLong(index);
    }

    public double getDouble(ResultSet resultSet, int index) throws Exception {
        return resultSet.getDouble(index);
    }

    public DateTime getDateTime(ResultSet resultSet, int type, int index) throws Exception {
        Timestamp time = resultSet.getTimestamp(index);
        DateTime d = null;
        d = time == null ? new DateTime() : new DateTime(time, type);
        return d;
    }

    public DateTime getDateTime(ResultSet resultSet, int index) throws Exception {
        Timestamp time = resultSet.getTimestamp(index);
        DateTime d = null;
        d = time == null ? new DateTime() : new DateTime(time, 13);
        return d;
    }

    public DateTime getDateTime(ResultSet resultSet, String name) throws Exception {
        Timestamp time = resultSet.getTimestamp(name);
        DateTime d = null;
        d = time == null ? new DateTime() : new DateTime(time, 13);
        return d;
    }

    public byte[] getBytes(ResultSet resultSet, int index) throws Exception {
        return resultSet.getBytes(index);
    }

    public String getString(ResultSet resultSet, String name) throws Exception {
        String value = resultSet.getString(name);
        value = DataUtils.dbNullToEmpty(value);
        if (!(!this.dbDataSource.isNeedConvertFromDbToServer() || this.dbDataSource.getDbToServerDecodeCharset().equals("") && this.dbDataSource.getDbToServerEncodeCharset().equals(""))) {
            value = this.dbDataSource.getDbToServerDecodeCharset().equals("") ? new String(value.getBytes(), this.dbDataSource.getDbToServerEncodeCharset()) : (this.dbDataSource.getDbToServerEncodeCharset().equals("") ? new String(value.getBytes(this.dbDataSource.getDbToServerDecodeCharset())) : new String(value.getBytes(this.dbDataSource.getDbToServerDecodeCharset()), this.dbDataSource.getDbToServerEncodeCharset()));
        }
        if (this.useTrim) {
            value = StringUtils.rightTrim(value);
        }
        return value;
    }

    public int getInt(ResultSet resultSet, String name) throws Exception {
        return resultSet.getInt(name);
    }

    public long getLong(ResultSet resultSet, String name) throws Exception {
        return resultSet.getLong(name);
    }

    public double getDouble(ResultSet resultSet, String name) throws Exception {
        return resultSet.getDouble(name);
    }

    public DateTime getDateTime(ResultSet resultSet, int type, String name) throws Exception {
        Timestamp time = resultSet.getTimestamp(name);
        DateTime d = null;
        d = time == null ? new DateTime() : new DateTime(time, type);
        return d;
    }

    public byte[] getBytes(ResultSet resultSet, String name) throws Exception {
        return resultSet.getBytes(name);
    }

    public ResultSet executeQuery(String sqlString) throws Exception {
        sqlString = sqlString.trim();
        this.logSQL(sqlString);
        if (!(!this.dbDataSource.isNeedConvertFromServerToDb() || this.dbDataSource.getServerToDbDecodeCharset().equals("") && this.dbDataSource.getServerToDbEncodeCharset().equals(""))) {
            sqlString = this.dbDataSource.getServerToDbDecodeCharset().equals("") ? new String(sqlString.getBytes(), this.dbDataSource.getServerToDbEncodeCharset()) : (this.dbDataSource.getServerToDbEncodeCharset().equals("") ? new String(sqlString.getBytes(this.dbDataSource.getServerToDbDecodeCharset())) : new String(sqlString.getBytes(this.dbDataSource.getServerToDbDecodeCharset()), this.dbDataSource.getServerToDbEncodeCharset()));
        }
        if (sqlString.toUpperCase().startsWith("SELECT COUNT(*) FROM")) {
            sqlString = SqlUtils.getWherePartForGetCount(sqlString);
        }
        this.resultSet = this.statement.executeQuery(sqlString);
        return this.resultSet;
    }

    public void locate(ResultSet resultSet, int position) throws Exception {
        try {
            resultSet.absolute(position);
        }
        catch (Exception e) {
            for (int i = 0; i < position; ++i) {
                resultSet.next();
            }
        }
    }

    public int executeUpdate(String sqlString) throws Exception {
        this.logSQL(sqlString);
        if (!(!this.dbDataSource.isNeedConvertFromServerToDb() || this.dbDataSource.getServerToDbDecodeCharset().equals("") && this.dbDataSource.getServerToDbEncodeCharset().equals(""))) {
            sqlString = this.dbDataSource.getServerToDbDecodeCharset().equals("") ? new String(sqlString.getBytes(), this.dbDataSource.getServerToDbEncodeCharset()) : (this.dbDataSource.getServerToDbEncodeCharset().equals("") ? new String(sqlString.getBytes(this.dbDataSource.getServerToDbDecodeCharset())) : new String(sqlString.getBytes(this.dbDataSource.getServerToDbDecodeCharset()), this.dbDataSource.getServerToDbEncodeCharset()));
        }
        int result = this.statement.executeUpdate(sqlString);
        return result;
    }

    public int executePreparedUpdate() throws Exception {
        int result = this.preparedStatement.executeUpdate();
        return result;
    }

    public ResultSet executePreparedQuery() throws Exception {
        this.resultSet = this.preparedStatement.executeQuery();
        return this.resultSet;
    }

    public boolean hasColumn(String tableName, String columnName) throws SQLException, Exception {
        boolean blnFoundFlag = false;
        String key = tableName + "^" + columnName;
        if (tableColumns.containsKey(key = key.toLowerCase())) {
            return (Boolean)tableColumns.get(key);
        }
        String sqlString = " SELECT " + columnName + " FROM " + tableName + " WHERE 1=0";
        try {
            this.statement.executeQuery(sqlString);
            blnFoundFlag = true;
        }
        catch (SQLException e) {
            blnFoundFlag = false;
        }
        tableColumns.put(key, blnFoundFlag);
        return blnFoundFlag;
    }

    public void setUseTrim(boolean useTrim) {
        this.useTrim = useTrim;
    }

    public int getCount(String statement) throws Exception {
        this.logSQL(statement);
        int count = -1;
        ResultSet resultSet = this.executeQuery(statement);
        resultSet.next();
        count = this.getInt(resultSet, 1);
        resultSet.close();
        return count;
    }

    public String[] getTableColumnNames(String tableName) throws Exception {
        this.resultSet = this.statement.executeQuery("SELECT * FROM " + tableName + " WHERE 1=0");
        ResultSetMetaData rmeta = this.resultSet.getMetaData();
        int numColumns = rmeta.getColumnCount();
        String[] columns = new String[numColumns];
        for (int i = 1; i <= numColumns; ++i) {
            columns[i - 1] = rmeta.getColumnName(i);
        }
        return columns;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public String getDSName() {
        return this.dbDataSource.getName();
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public static Map getConnectionMap() {
        return connectionMap;
    }

    public static Map getSqlMap() {
        return sqlMap;
    }

    public static String getSqlMapString() {
        Iterator keyIter = sqlMap.keySet().iterator();
        StringBuffer buffer = new StringBuffer();
        Iterator iter = keyIter;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            List list = (List)sqlMap.get(key);
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(list.get(i)).append("\r\n");
            }
            buffer.append("\r\n");
        }
        return buffer.toString();
    }

    public static void killConnection(String key) throws Exception {
        if (connectionMap.containsKey(key)) {
            Connection conn = (Connection)connectionMap.get(key);
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
            connectionMap.remove(key);
            sqlMap.remove(key);
        }
    }

    private void logSQL(String sql) {
        if (this.logger.isDebugEnabled()) {
            this.sqlList.add(new Date() + ":" + sql);
        }
    }

    private static String getStackTrace(String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ExceptionUtils.getExceptionStackTraceString(new Exception(message)));
        return buffer.toString();
    }

    private void injectParamValues(Object[] values) throws Exception {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value instanceof String) {
                this.setString(i + 1, (String)value);
                continue;
            }
            if (value instanceof Integer) {
                this.setInt(i + 1, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                this.setLong(i + 1, (Long)value);
                continue;
            }
            if (value instanceof DateTime) {
                this.setDateTime(i + 1, (DateTime)value);
                continue;
            }
            if (value instanceof Double) {
                this.setDouble(i + 1, (Double)value);
                continue;
            }
            throw new IllegalArgumentException("Unsupport type " + value.getClass().getName());
        }
    }

    static {
        DBManager.initContextProps();
    }
}

