/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.reference;

import com.sinosoft.sysframework.reference.ServiceProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JNDIServiceLocator {
    private static JNDIServiceLocator instance = null;
    private Map ejbHomes;
    private Context initialContext = this.getInitialContext();

    public static JNDIServiceLocator getInstance() throws Exception {
        if (instance == null) {
            instance = new JNDIServiceLocator();
        }
        return instance;
    }

    public Object lookupByName(String ref) throws Exception {
        Object home = this.ejbHomes.get(ref);
        if (home == null) {
            home = this.initialContext.lookup(ref);
            this.ejbHomes.put(ref, home);
        }
        return home;
    }

    protected JNDIServiceLocator() throws NamingException, Exception {
        this.ejbHomes = Collections.synchronizedMap(new HashMap());
    }

    private Context getInitialContext() throws Exception {
        String user = ServiceProperty.getUser();
        String password = ServiceProperty.getPassword();
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", ServiceProperty.getInitialContextFactory());
        properties.put("java.naming.provider.url", ServiceProperty.getServiceUrl());
        if (user != null && !user.equals("")) {
            properties.put("java.naming.security.principal", user);
            properties.put("java.naming.security.credentials", password == null ? "" : password);
        }
        return new InitialContext(properties);
    }
}

