/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.validate;

import java.util.Locale;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.util.ValidatorUtils;

public class CommonValidator {
    public static final String FIELD_TEST_NULL = "NULL";
    public static final String FIELD_TEST_NOTNULL = "NOTNULL";
    public static final String FIELD_TEST_EQUAL = "EQUAL";
    private static Class stringClass = class$java$lang$String == null ? (class$java$lang$String = CommonValidator.class$("java.lang.String")) : class$java$lang$String;
    static /* synthetic */ Class class$java$lang$String;

    public static boolean validateRaiseException(Object bean, Field field) throws Exception {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if ("RUNTIME".equals(value)) {
            throw new RuntimeException("RUNTIME-EXCEPTION");
        }
        if ("CHECKED".equals(value)) {
            throw new Exception("CHECKED-EXCEPTION");
        }
        throw new ValidatorException("VALIDATOR-EXCEPTION");
    }

    public static boolean validateRequired(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return !GenericValidator.isBlankOrNull((String)value);
    }

    public static boolean validateByte(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        return GenericValidator.isByte((String)value);
    }

    public static boolean validateShort(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        return GenericValidator.isShort((String)value);
    }

    public static boolean validateInteger(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        return GenericValidator.isInt((String)value);
    }

    public static boolean validateIntegerRange(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                int intValue = Integer.parseInt(value);
                int min = Integer.parseInt(field.getVarValue("min"));
                int max = Integer.parseInt(field.getVarValue("max"));
                if (!GenericValidator.isInRange((int)intValue, (int)min, (int)max)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean validateMask(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        String mask = field.getVarValue("mask");
        return GenericValidator.isBlankOrNull((String)value) || GenericValidator.matchRegexp((String)value, (String)mask);
    }

    public static boolean validatePositive(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        return GenericTypeValidator.formatInt((String)value) > 0;
    }

    public static boolean validateLong(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        return GenericValidator.isLong((String)value);
    }

    public static boolean validateFloat(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        return GenericValidator.isFloat((String)value);
    }

    public static boolean validateFloatRange(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                float floatValue = Float.parseFloat(value);
                float min = Float.parseFloat(field.getVarValue("min"));
                float max = Float.parseFloat(field.getVarValue("max"));
                if (!GenericValidator.isInRange((float)floatValue, (float)min, (float)max)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean validateDouble(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        return GenericValidator.isDouble((String)value);
    }

    public static boolean validateDoubleRange(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                double doubleValue = Double.parseDouble(value);
                double min = Double.parseDouble(field.getVarValue("min"));
                double max = Double.parseDouble(field.getVarValue("max"));
                if (!GenericValidator.isInRange((double)doubleValue, (double)min, (double)max)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean validateDate(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        String datePattern = field.getVarValue("datePattern");
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        boolean result = true;
        try {
            if (datePattern != null && datePattern.length() > 0) {
                GenericTypeValidator.formatDate((String)value, (String)datePattern, (boolean)false);
            } else {
                GenericTypeValidator.formatDate((String)value, (Locale)Locale.getDefault());
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean validateMinLength(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                int min = Integer.parseInt(field.getVarValue("minLength"));
                if (value.getBytes().length < min) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean validateMaxLength(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                int max = Integer.parseInt(field.getVarValue("maxLength"));
                if (value.getBytes().length > max) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean validateEmail(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        return GenericValidator.isEmail((String)value);
    }

    public static boolean validateRequiredIf(Object bean, Field field, Validator validator) {
        Object form = validator.getParameterValue("java.lang.Object");
        String value = null;
        boolean required = false;
        value = CommonValidator.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        int i = 0;
        String fieldJoin = "AND";
        if (!GenericValidator.isBlankOrNull((String)field.getVarValue("fieldJoin"))) {
            fieldJoin = field.getVarValue("fieldJoin");
        }
        if (fieldJoin.equalsIgnoreCase("AND")) {
            required = true;
        }
        while (!GenericValidator.isBlankOrNull((String)field.getVarValue("field[" + i + "]"))) {
            String key;
            String dependProp = field.getVarValue("field[" + i + "]");
            String dependTest = field.getVarValue("fieldTest[" + i + "]");
            String dependTestValue = field.getVarValue("fieldValue[" + i + "]");
            String dependIndexed = field.getVarValue("fieldIndexed[" + i + "]");
            if (dependIndexed == null) {
                dependIndexed = "false";
            }
            String dependVal = null;
            boolean this_required = false;
            if (field.isIndexed() && dependIndexed.equalsIgnoreCase("true") && (key = field.getKey()).indexOf("[") > -1 && key.indexOf("]") > -1) {
                String ind = key.substring(0, key.indexOf(".") + 1);
                dependProp = ind + dependProp;
            }
            dependVal = ValidatorUtils.getValueAsString((Object)form, (String)dependProp);
            if (dependTest.equals(FIELD_TEST_NULL)) {
                this_required = dependVal == null || dependVal.length() <= 0;
            }
            if (dependTest.equals(FIELD_TEST_NOTNULL)) {
                this_required = dependVal != null && dependVal.length() > 0;
            }
            if (dependTest.equals(FIELD_TEST_EQUAL)) {
                this_required = dependTestValue.equalsIgnoreCase(dependVal);
            }
            required = fieldJoin.equalsIgnoreCase("AND") ? required && this_required : required || this_required;
            ++i;
        }
        if (required) {
            return value != null && value.length() > 0;
        }
        return true;
    }

    private static boolean isString(Object o) {
        if (o == null) {
            return true;
        }
        return stringClass.isInstance(o);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

