/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.validate;

import com.sinosoft.sysframework.common.AppUtils;
import com.sinosoft.sysframework.common.util.ObjectUtils;
import com.sinosoft.sysframework.exception.DataVerifyException;
import com.sinosoft.sysframework.exception.ExceptionCause;
import com.sinosoft.sysframework.validate.Resources;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;

public class ValidateHelper {
    public static void validate(String formName, Object formBean, HttpServletRequest request) throws Exception {
        DataVerifyException exception = new DataVerifyException();
        ValidatorResources resources = AppUtils.getValidatorResources();
        Validator validator = new Validator(resources, formName);
        Form form = resources.getForm(request.getLocale(), formName);
        ValidateHelper.validateRecursive(form, formBean, request, validator, resources, exception, -1);
        if (exception.getCauseList().size() > 0) {
            throw exception;
        }
    }

    private static void validateRecursive(Form form, Object formBean, HttpServletRequest request, Validator validator, ValidatorResources resources, DataVerifyException exception, int index) throws Exception {
        if (formBean == null) {
            return;
        }
        validator.setParameter("java.lang.Object", formBean);
        validator.setOnlyReturnErrors(true);
        ValidatorResults results = validator.validate();
        Iterator iPropertyNames = results.getPropertyNames().iterator();
        while (iPropertyNames.hasNext()) {
            String propertyName = (String)iPropertyNames.next();
            Field field = form.getField(propertyName);
            ValidatorResult result = results.getValidatorResult(propertyName);
            Iterator iActions = result.getActions();
            while (iActions.hasNext()) {
                String actionName = (String)iActions.next();
                if (result.isValid(actionName)) continue;
                try {
                    BeanUtils.getProperty((Object)formBean, (String)field.getProperty());
                    ValidatorAction action = resources.getValidatorAction(actionName);
                    ExceptionCause exceptionCause = Resources.getActionMessage(validator, request, action, field);
                    exceptionCause.setIndex(index);
                    exception.addCause(exceptionCause);
                }
                catch (Exception e) {}
            }
        }
        if (formBean instanceof String || formBean instanceof Number || formBean instanceof java.util.Date || formBean instanceof Date) {
            return;
        }
        List getter = ObjectUtils.getGetter(formBean.getClass());
        for (int i = 0; i < getter.size(); ++i) {
            Collection childList;
            Method method = (Method)getter.get(i);
            if (Modifier.isPrivate(method.getModifiers()) || method.getParameterTypes() == null || method.getParameterTypes().length > 0) continue;
            Object property = method.invoke(formBean, new Object[0]);
            if (property instanceof List) {
                childList = (List)property;
                for (int j = 0; j < childList.size(); ++j) {
                    Object object = childList.get(j);
                    ValidateHelper.validateRecursive(form, object, request, validator, resources, exception, j);
                }
                continue;
            }
            if (property instanceof Collection) {
                childList = (Collection)property;
                int childIndex = 0;
                Iterator iter = childList.iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    ValidateHelper.validateRecursive(form, element, request, validator, resources, exception, childIndex++);
                }
                continue;
            }
            ValidateHelper.validateRecursive(form, property, request, validator, resources, exception, -1);
        }
    }
}

