/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.web.control;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheFilter
implements Filter {
    private static final String FILTER_TAG = "sinosoft.servlet.cache.filter";
    private int time = 0;
    private static Log logger = LogFactory.getLog((Class)(class$com$sinosoft$sysframework$web$control$CacheFilter == null ? (class$com$sinosoft$sysframework$web$control$CacheFilter = CacheFilter.class$("com.sinosoft.sysframework.web.control.CacheFilter")) : class$com$sinosoft$sysframework$web$control$CacheFilter));
    static /* synthetic */ Class class$com$sinosoft$sysframework$web$control$CacheFilter;

    public void init(FilterConfig filterConfig) {
        String expireTime = filterConfig.getInitParameter("expireTime");
        if (expireTime != null) {
            try {
                this.time = Integer.parseInt(expireTime);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)"init parameter expireTime must be a int");
                this.time = 0;
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletResponse) || !(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        if (request.getAttribute(FILTER_TAG) != null) {
            chain.doFilter(request, response);
            return;
        }
        request.setAttribute(FILTER_TAG, (Object)"true");
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (this.time > 0) {
            res.setHeader("Cache-Control", "max-age=" + this.time);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("set max-age for " + req.getRequestURI()));
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

