/*
 * Decompiled with CFR 0.152.
 */
package net.vicp.vissoft.util;

import java.util.Arrays;
import net.vicp.vissoft.util.PrintUtils;
import net.vicp.vissoft.util.StringUtils;

public class CodeUtils {
    public static byte[] hexStringToByteArray(String value) {
        value = value.replaceAll(" ", "");
        int len = value.length() / 2;
        byte[] result = new byte[len];
        char[] achar = value.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(CodeUtils.charToByte(achar[pos]) << 4 | CodeUtils.charToByte(achar[pos + 1]));
        }
        return result;
    }

    public static final String byteArrayToBinString(byte[] val, boolean withSpace) {
        StringBuffer sb = new StringBuffer(val.length);
        for (int i = 0; i < val.length; ++i) {
            String sTemp = Integer.toBinaryString(0xFF & val[i]);
            if (sTemp.length() < 8) {
                sb.append(StringUtils.newString('0', 8 - sTemp.length()));
            }
            sb.append(sTemp.toUpperCase());
            if (!withSpace) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static final String byteArrayToBinString(byte[] val) {
        return CodeUtils.byteArrayToBinString(val, true);
    }

    public static final String byteArrayToHexString(byte[] val, boolean withSpace) {
        StringBuffer sb = new StringBuffer(val.length);
        for (int i = 0; i < val.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & val[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
            if (!withSpace) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static final String byteArrayToHexString(byte[] val) {
        return CodeUtils.byteArrayToHexString(val, true);
    }

    private static byte charToByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }

    public static byte[] bcdArrayToAscArray(byte[] src) {
        byte[] result = new byte[src.length * 2];
        for (int i = 0; i < src.length; ++i) {
            result[i * 2] = (byte)(src[i] >>> 4 & 0xF);
            result[i * 2 + 1] = (byte)(src[i] & 0xF);
        }
        return result;
    }

    public static String bcdByteArrayToString(byte[] src) {
        byte[] value = CodeUtils.bcdArrayToAscArray(src);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            String str = Integer.toHexString(value[i] & 0xFF);
            buffer.append(str);
        }
        return buffer.toString();
    }

    public static byte[] stringToBcdByteArray(String src) {
        int len = src.length();
        int mod = len % 2;
        if (mod != 0) {
            src = "0" + src;
            len = src.length();
        }
        byte[] abt = new byte[len];
        if (len >= 2) {
            len /= 2;
        }
        byte[] bbt = new byte[len];
        abt = src.getBytes();
        for (int p = 0; p < src.length() / 2; ++p) {
            byte b;
            int j = abt[2 * p] >= 48 && abt[2 * p] <= 57 ? abt[2 * p] - 48 : (abt[2 * p] >= 97 && abt[2 * p] <= 122 ? abt[2 * p] - 97 + 10 : abt[2 * p] - 65 + 10);
            int k = abt[2 * p + 1] >= 48 && abt[2 * p + 1] <= 57 ? abt[2 * p + 1] - 48 : (abt[2 * p + 1] >= 97 && abt[2 * p + 1] <= 122 ? abt[2 * p + 1] - 97 + 10 : abt[2 * p + 1] - 65 + 10);
            int a = (j << 4) + k;
            bbt[p] = b = (byte)a;
        }
        return bbt;
    }

    public static void main(String[] args) {
        byte[] data = new byte[16];
        for (int i = 0; i < 16; ++i) {
            data[i] = (byte)(Math.random() * 16.0 + 49.0);
        }
        PrintUtils.hexPrint(data, false);
    }

    public static byte[] xor(byte[] src, int packageSize) {
        byte[] result = new byte[packageSize];
        System.arraycopy(src, 0, result, 0, packageSize);
        for (int i = packageSize; i < src.length; i += packageSize) {
            byte[] tempSrc = new byte[packageSize];
            Arrays.fill(tempSrc, (byte)0);
            int len = src.length - i;
            if (len > packageSize) {
                len = packageSize;
            }
            System.arraycopy(src, i, tempSrc, 0, len);
            for (int j = 0; j < tempSrc.length; ++j) {
                result[j] = (byte)(result[j] ^ tempSrc[j]);
            }
        }
        return result;
    }

    public static boolean equal(byte[] value1, byte[] value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null) {
            return false;
        }
        if (value2 == null) {
            return false;
        }
        if (value1.length != value2.length) {
            return false;
        }
        for (int i = 0; i < value1.length; ++i) {
            if (value1[i] == value2[i]) continue;
            return false;
        }
        return true;
    }
}

