/*
 * Decompiled with CFR 0.152.
 */
package net.vicp.vissoft.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class NetIP {
    public static void main(String[] args) throws Exception {
        System.out.println(NetIP.getLocalIP());
    }

    public static String getLocalIP() {
        String osName = System.getProperty("os.name").toLowerCase();
        try {
            if (osName.startsWith("linux")) {
                return NetIP.getLocalLinuxIP();
            }
            if (osName.startsWith("window")) {
                return NetIP.getLocalWindowsIP();
            }
            if (osName.startsWith("aix")) {
                return NetIP.getLocalAixIP();
            }
            throw new IllegalStateException("Not support OS:" + osName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getLocalLinuxIP() throws Exception {
        String s;
        Runtime rt = Runtime.getRuntime();
        Process process = rt.exec("ip addr");
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((s = in.readLine()) != null) {
            int pos;
            String ip;
            if (!(s = s.trim()).startsWith("inet ") || (ip = (s = s.substring("inet ".length()).trim()).substring(0, pos = s.indexOf("/")).trim()).startsWith("127.")) continue;
            return ip;
        }
        return "127.0.0.1";
    }

    private static String getLocalWindowsIP() throws Exception {
        String s;
        Runtime rt = Runtime.getRuntime();
        Process process = rt.exec("ipconfig /all");
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((s = in.readLine()) != null) {
            String ip;
            int pos;
            if (!(s = s.trim()).startsWith("IP Address") || (pos = (s = s.substring("IP Address".length()).trim()).indexOf(": ")) <= -1 || (ip = s.substring(pos + ": ".length()).trim()).startsWith("127.")) continue;
            return ip;
        }
        return "127.0.0.1";
    }

    private static String getLocalAixIP() throws Exception {
        String s;
        Runtime rt = Runtime.getRuntime();
        Process process = rt.exec("ifconfig -a");
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((s = in.readLine()) != null) {
            String ip;
            int pos;
            if (!(s = s.trim()).startsWith("inet ") || (pos = (s = s.substring("inet ".length()).trim()).indexOf("netmask")) <= -1 || (ip = s.substring(0, pos).trim()).startsWith("127.")) continue;
            return ip;
        }
        return "127.0.0.1";
    }
}

