/*
 * Decompiled with CFR 0.152.
 */
package net.vicp.vissoft.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class NetMAC {
    public static void main(String[] args) throws Exception {
        System.out.println(NetMAC.getLocalMAC());
    }

    public static String getLocalMAC() {
        String osName = System.getProperty("os.name").toLowerCase();
        try {
            if (osName.startsWith("linux")) {
                return NetMAC.getLocalLinuxMAC();
            }
            if (osName.startsWith("window")) {
                return NetMAC.getLocalWindowsMAC();
            }
            throw new IllegalStateException("Not support OS:" + osName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getLocalLinuxMAC() throws Exception {
        String s;
        Runtime rt = Runtime.getRuntime();
        Process process = rt.exec("ip addr");
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((s = in.readLine()) != null) {
            if (!(s = s.trim()).startsWith("link/ether ")) continue;
            s = s.substring("link/ether ".length()).trim();
            int pos = s.indexOf(" ");
            String mac = s.substring(0, pos).trim();
            return mac;
        }
        return null;
    }

    private static String getLocalWindowsMAC() throws Exception {
        String s;
        Runtime rt = Runtime.getRuntime();
        Process process = rt.exec("ipconfig /all");
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((s = in.readLine()) != null) {
            int pos;
            if (!(s = s.trim()).startsWith("Physical Address") || (pos = (s = s.substring("Physical Address".length()).trim()).indexOf(": ")) <= -1) continue;
            String mac = s.substring(pos + ": ".length()).trim();
            return mac;
        }
        return null;
    }
}

