/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.cluster;

import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.ForwardRequest;
import weblogic.corba.client.cluster.ClusterComponent;
import weblogic.corba.client.cluster.ClusterComponentHelper;
import weblogic.corba.client.cluster.TargetInfo;
import weblogic.corba.client.cluster.VendorInfoCluster;
import weblogic.corba.client.cluster.VendorInfoClusterHelper;

public final class ClusterInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    static final int TAG_WLS_CLUSTER_KEY = 1111834883;
    static final int VENDOR_INFO_CLUSTER = 1111834883;
    static final String COMM_FAILURE_ID = "IDL:omg.org/CORBA/COMM_FAILURE:1.0";
    static final String MARSHAL_ID = "IDL:omg.org/CORBA/MARSHAL:1.0";
    static final String OBJECT_NOT_EXIST_ID = "IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0";
    static final String BAD_PARAM_ID = "IDL:omg.org/CORBA/BAD_PARAM:1.0";
    private static final boolean DEBUG = ClusterInterceptor.getDebug();
    private Current piCurrent;
    private Codec codec;
    private int slot;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.cluster");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ClusterInterceptor(Current current, Codec codec, int n) {
        this.piCurrent = current;
        this.codec = codec;
        this.slot = n;
    }

    public String name() {
        return "ClusterInterceptor";
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        block10: {
            if (DEBUG) {
                ClusterInterceptor.p("send_request(effective: " + ClusterInterceptor.printObject(clientRequestInfo.effective_target()) + ", target: " + ClusterInterceptor.printObject(clientRequestInfo.target()) + "." + clientRequestInfo.operation() + ")");
            }
            try {
                Object object;
                TargetInfo targetInfo = TargetInfo.findTargetInfo(clientRequestInfo.effective_target());
                if (targetInfo == null) {
                    targetInfo = TargetInfo.findOrCreateTargetInfo(clientRequestInfo.effective_target(), this.getClusterComponent(clientRequestInfo), this.codec);
                }
                if ((object = this.loadBalance(clientRequestInfo)) != null && object != clientRequestInfo.effective_target()) {
                    if (DEBUG) {
                        ClusterInterceptor.p("forwarding to: " + ClusterInterceptor.printObject(object));
                    }
                    throw new ForwardRequest(object);
                }
                if (targetInfo != null && targetInfo != TargetInfo.NULL_TARGET_INFO) {
                    if (DEBUG) {
                        ClusterInterceptor.p("sending version: " + targetInfo.getVersion() + " for " + clientRequestInfo.operation() + "()");
                    }
                    clientRequestInfo.add_request_service_context(targetInfo.getVersionContext(), true);
                }
            }
            catch (TypeMismatch typeMismatch) {
                if (DEBUG) {
                    ClusterInterceptor.p("bad cluster key in request target for: " + clientRequestInfo.operation() + "()");
                }
            }
            catch (FormatMismatch formatMismatch) {
                if (!DEBUG) break block10;
                ClusterInterceptor.p("bad cluster key in request target for: " + clientRequestInfo.operation() + "()");
            }
        }
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
        if (DEBUG) {
            ClusterInterceptor.p("send_poll(" + clientRequestInfo.operation() + ")");
        }
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
        block6: {
            if (DEBUG) {
                ClusterInterceptor.p("receive_reply(" + clientRequestInfo.operation() + ")");
            }
            try {
                VendorInfoCluster vendorInfoCluster = this.getClusterContext(clientRequestInfo);
                TargetInfo.updateTargetInfo(clientRequestInfo.effective_target(), vendorInfoCluster, this.codec);
                if (DEBUG && vendorInfoCluster != null) {
                    ClusterInterceptor.p("updated version: " + vendorInfoCluster.version + " for " + vendorInfoCluster.replicas.length + " entries");
                }
            }
            catch (TypeMismatch typeMismatch) {
                if (DEBUG) {
                    ClusterInterceptor.p("bad cluster context in request target for: " + clientRequestInfo.operation() + "()");
                }
            }
            catch (FormatMismatch formatMismatch) {
                if (!DEBUG) break block6;
                ClusterInterceptor.p("bad cluster context in request target for: " + clientRequestInfo.operation() + "()");
            }
        }
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        Object object;
        if (DEBUG) {
            ClusterInterceptor.p("receive_exception(" + clientRequestInfo.operation() + ")");
        }
        if ((object = this.failOver(clientRequestInfo)) != null && object != clientRequestInfo.effective_target()) {
            if (DEBUG) {
                ClusterInterceptor.p("failing over to: " + ClusterInterceptor.printObject(object));
            }
            throw new ForwardRequest(object);
        }
        if (DEBUG) {
            ClusterInterceptor.p("couldn't fail over");
        }
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) {
        if (DEBUG) {
            ClusterInterceptor.p("receive_other(" + clientRequestInfo.operation() + ")");
        }
    }

    public Object loadBalance(ClientRequestInfo clientRequestInfo) {
        TargetInfo targetInfo = TargetInfo.findTargetInfo(clientRequestInfo.effective_target());
        if (targetInfo == null || targetInfo == TargetInfo.NULL_TARGET_INFO || targetInfo.onlyOneTarget()) {
            if (DEBUG) {
                ClusterInterceptor.p("target info was null or useless");
            }
            return null;
        }
        if (targetInfo.invoking()) {
            targetInfo.setInvoking(false);
            if (DEBUG) {
                ClusterInterceptor.p("already invoking");
            }
            return null;
        }
        Object object = targetInfo.selectNextTarget();
        if (object == null) {
            if (DEBUG) {
                ClusterInterceptor.p("target for: " + clientRequestInfo.operation() + "() unchanged");
            }
            return null;
        }
        targetInfo.setInvoking(true);
        if (DEBUG) {
            ClusterInterceptor.p("got target info for: " + clientRequestInfo.operation() + "()");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object failOver(ClientRequestInfo clientRequestInfo) {
        if (clientRequestInfo.reply_status() == 1) {
            Any any = clientRequestInfo.received_exception();
            InputStream inputStream = any.create_input_stream();
            String string = inputStream.read_string();
            int n = inputStream.read_long();
            int n2 = inputStream.read_long();
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string.equals(COMM_FAILURE_ID) || string.equals(MARSHAL_ID) || string.equals(OBJECT_NOT_EXIST_ID) || string.equals(BAD_PARAM_ID) && n == 1330446344) {
                TargetInfo targetInfo;
                if (DEBUG) {
                    ClusterInterceptor.p("failOver(): received " + string + " exception for " + clientRequestInfo.operation() + "()");
                }
                if ((targetInfo = TargetInfo.findTargetInfo(clientRequestInfo.effective_target())) == null || targetInfo == TargetInfo.NULL_TARGET_INFO) {
                    return null;
                }
                TargetInfo targetInfo2 = targetInfo;
                synchronized (targetInfo2) {
                    targetInfo = TargetInfo.findTargetInfo(clientRequestInfo.effective_target());
                    if (targetInfo == null || targetInfo == TargetInfo.NULL_TARGET_INFO) {
                        return null;
                    }
                    targetInfo.removeMember(clientRequestInfo.effective_target());
                    if (DEBUG) {
                        ClusterInterceptor.p("failOver(): " + targetInfo.getReplicas().length + " replicas to choose from, " + n2 + " " + targetInfo.clusterComponent.idempotent);
                    }
                    if (targetInfo.getReplicas() != null && targetInfo.getReplicas().length > 0 && (n2 == 1 || n2 == 2 && targetInfo.clusterComponent.idempotent)) {
                        targetInfo.setInvoking(true);
                        return targetInfo.selectFailoverTarget();
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private ClusterComponent getClusterComponent(ClientRequestInfo clientRequestInfo) throws TypeMismatch, FormatMismatch {
        try {
            if (DEBUG) {
                ClusterInterceptor.p("looking for cluster component for " + ClusterInterceptor.printObject(clientRequestInfo.effective_target()));
            }
            TaggedComponent taggedComponent = clientRequestInfo.get_effective_component(1111834883);
            Any any = this.codec.decode_value(taggedComponent.component_data, ClusterComponentHelper.type());
            ClusterComponent clusterComponent = ClusterComponentHelper.extract(any);
            if (DEBUG) {
                ClusterInterceptor.p("found cluster component " + (clusterComponent.replicas == null ? 0 : clusterComponent.replicas.length) + " replicas, algorithm `" + clusterComponent.algorithm + "', version " + clusterComponent.version);
            }
            return clusterComponent;
        }
        catch (BAD_PARAM bAD_PARAM) {
            if (bAD_PARAM.minor != 1330446364) {
                if (DEBUG) {
                    bAD_PARAM.printStackTrace();
                }
                throw bAD_PARAM;
            }
            return null;
        }
    }

    private VendorInfoCluster getClusterContext(ClientRequestInfo clientRequestInfo) throws TypeMismatch, FormatMismatch {
        try {
            ServiceContext serviceContext = clientRequestInfo.get_reply_service_context(1111834883);
            if (DEBUG) {
                ClusterInterceptor.p("found cluster context for " + clientRequestInfo.operation() + "()");
            }
            Any any = this.codec.decode_value(serviceContext.context_data, VendorInfoClusterHelper.type());
            return VendorInfoClusterHelper.extract(any);
        }
        catch (BAD_PARAM bAD_PARAM) {
            if (bAD_PARAM.minor != 1330446362) {
                if (DEBUG) {
                    bAD_PARAM.printStackTrace();
                }
                throw bAD_PARAM;
            }
            return null;
        }
    }

    protected static void p(String string) {
        System.err.println("<ClusterInterceptor> " + string);
    }

    private static final Delegate delegate(Object object) {
        return ((ObjectImpl)object)._get_delegate();
    }

    static final String printObject(Object object) {
        if (object == null) {
            return "<null>";
        }
        StringBuffer stringBuffer = new StringBuffer("<Typeids: [");
        String[] stringArray = ((ObjectImpl)object)._ids();
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("; ");
            }
            stringBuffer.append(stringArray[stringArray.length - 1]);
        }
        stringBuffer.append("], Stub: ");
        return stringBuffer.append(object.getClass().getName()).append(">: ").append(ClusterInterceptor.printObject(ClusterInterceptor.delegate(object))).toString();
    }

    static final String printObject(Delegate delegate) {
        StringBuffer stringBuffer = new StringBuffer("<");
        stringBuffer.append(Integer.toHexString(delegate.hashCode()));
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

