/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.iiop;

import java.net.UnknownHostException;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;

public final class BiDirInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final boolean DEBUG = BiDirInterceptor.getDebug();
    public static final String NAME = "BiDirInterceptor";
    private final Codec codec;
    private ServiceContext info;
    private ListenPoint listenPoint = null;
    private Runnable deferredRegistration;
    private static final int BI_DIR_IIOP = 5;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.iiop");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public BiDirInterceptor(Codec codec) throws UnknownHostException {
        this.codec = codec;
    }

    final synchronized void setListenPoint(ListenPoint listenPoint) {
        byte[] byArray;
        block3: {
            byArray = null;
            try {
                Any any = ORB.init().create_any();
                if (DEBUG) {
                    BiDirInterceptor.p("listen point is: " + listenPoint.host + ":" + listenPoint.port);
                }
                BiDirIIOPServiceContextHelper.insert(any, new BiDirIIOPServiceContext(new ListenPoint[]{listenPoint}));
                byArray = this.codec.encode_value(any);
            }
            catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                if (!DEBUG) break block3;
                BiDirInterceptor.p("couldn't marshal BiDir context");
            }
        }
        this.info = new ServiceContext(5, byArray);
        this.listenPoint = listenPoint;
    }

    final synchronized void setDeferredRegistration(Runnable runnable) {
        this.deferredRegistration = runnable;
    }

    public String name() {
        return NAME;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (DEBUG) {
            BiDirInterceptor.p("send_request(<" + Integer.toHexString(clientRequestInfo.effective_target()._hash(Integer.MAX_VALUE)) + ">." + clientRequestInfo.operation() + "): " + this.listenPoint);
        }
        if (this.listenPoint != null) {
            clientRequestInfo.add_request_service_context(this.info, true);
        }
        if (this.deferredRegistration != null) {
            BiDirInterceptor biDirInterceptor = this;
            synchronized (biDirInterceptor) {
                if (this.deferredRegistration != null) {
                    Runnable runnable = this.deferredRegistration;
                    this.deferredRegistration = null;
                    runnable.run();
                }
            }
        }
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
        if (DEBUG) {
            BiDirInterceptor.p("send_poll(" + clientRequestInfo.operation() + ")");
        }
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
        if (DEBUG) {
            BiDirInterceptor.p("receive_reply(" + clientRequestInfo.operation() + ")");
        }
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (DEBUG) {
            BiDirInterceptor.p("receive_exception(" + clientRequestInfo.operation() + ")");
        }
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) {
        if (DEBUG) {
            BiDirInterceptor.p("receive_other(" + clientRequestInfo.operation() + ")");
        }
    }

    protected static void p(String string) {
        System.err.println("<BiDirInterceptor> " + string);
    }
}

