/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.security;

import org.omg.CORBA.Any;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.TaggedComponent;
import weblogic.corba.cos.security.GSSUtil;

public class CompoundSecMechListImpl {
    private static final boolean DEBUG = false;
    private CompoundSecMechList mechList;
    private TLS_SEC_TRANS tlsSecTrans;
    private Codec codec;
    private static final int SUPPORTED_TYPES = 15;

    public CompoundSecMechListImpl(CompoundSecMechList compoundSecMechList, Codec codec) {
        this.mechList = compoundSecMechList;
        this.codec = codec;
    }

    public final boolean hasGSSUP() {
        if (this.mechList.mechanism_list != null) {
            for (int i = 0; i < this.mechList.mechanism_list.length; ++i) {
                AS_ContextSec aS_ContextSec = this.mechList.mechanism_list[i].as_context_mech;
                if (aS_ContextSec == null || aS_ContextSec.target_supports == 0 || !GSSUtil.isGSSUPMech(aS_ContextSec.client_authentication_mech)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean hasGSSUPIdentity() {
        if (this.mechList.mechanism_list != null) {
            for (int i = 0; i < this.mechList.mechanism_list.length; ++i) {
                SAS_ContextSec sAS_ContextSec = this.mechList.mechanism_list[i].sas_context_mech;
                if (sAS_ContextSec == null || (sAS_ContextSec.target_supports & 0x400) == 0) continue;
                for (int j = 0; j < sAS_ContextSec.supported_naming_mechanisms.length; ++j) {
                    if (!GSSUtil.isGSSUPMech(sAS_ContextSec.supported_naming_mechanisms[j])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final byte[] getGSSUPTargetName() {
        if (this.mechList.mechanism_list != null) {
            for (int i = 0; i < this.mechList.mechanism_list.length; ++i) {
                if (this.mechList.mechanism_list[i].as_context_mech.target_name == null) continue;
                return this.mechList.mechanism_list[i].as_context_mech.target_name;
            }
        }
        return null;
    }

    public final String getSecureHost() {
        TLS_SEC_TRANS tLS_SEC_TRANS = this.getTLSSecTrans();
        if (tLS_SEC_TRANS != null && tLS_SEC_TRANS.addresses.length > 0) {
            return tLS_SEC_TRANS.addresses[0].host_name;
        }
        return null;
    }

    public final int getSecurePort() {
        TLS_SEC_TRANS tLS_SEC_TRANS = this.getTLSSecTrans();
        if (tLS_SEC_TRANS != null && tLS_SEC_TRANS.addresses.length > 0) {
            return tLS_SEC_TRANS.addresses[0].port;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TLS_SEC_TRANS getTLSSecTrans() {
        if (this.tlsSecTrans != null || this.mechList.mechanism_list == null) return this.tlsSecTrans;
        for (int i = 0; i < this.mechList.mechanism_list.length; ++i) {
            TaggedComponent taggedComponent = this.mechList.mechanism_list[i].transport_mech;
            if (taggedComponent.tag != 36) continue;
            try {
                Any any = this.codec.decode_value(taggedComponent.component_data, TLS_SEC_TRANSHelper.type());
                this.tlsSecTrans = TLS_SEC_TRANSHelper.extract(any);
                if (this.tlsSecTrans.addresses.length <= 0) continue;
            }
            catch (FormatMismatch formatMismatch) {
                continue;
            }
            catch (TypeMismatch typeMismatch) {
                // empty catch block
            }
        }
        return this.tlsSecTrans;
    }

    protected static void p(String string) {
        System.out.println("<CompoundSecMechListImpl>: " + string);
    }
}

