/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.security;

import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CSI.AuthorizationElement;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.IdentityToken;
import org.omg.GSSUP.InitialContextToken;
import org.omg.GSSUP.InitialContextTokenHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import weblogic.corba.client.security.ClientSecurityContext;
import weblogic.corba.client.security.CompoundSecMechListImpl;
import weblogic.corba.cos.security.GSSUtil;
import weblogic.security.auth.login.PasswordCredential;

public class EstablishContextImpl {
    private static final boolean DEBUG = false;
    private EstablishContext ctx = new EstablishContext();

    public EstablishContextImpl(CompoundSecMechListImpl compoundSecMechListImpl, Subject subject, Codec codec) throws InvalidTypeForEncoding, FormatMismatch, UnsupportedEncodingException {
        Object object;
        Set set;
        this.ctx.client_context_id = ClientSecurityContext.allocateClientContext(subject).getContextId();
        this.ctx.authorization_token = new AuthorizationElement[0];
        this.ctx.identity_token = new IdentityToken();
        Object var4_4 = null;
        PasswordCredential passwordCredential = null;
        if (subject != null) {
            set = subject.getPublicCredentials(PasswordCredential.class);
            Iterator iterator = set.iterator();
            if (iterator.hasNext()) {
                passwordCredential = (PasswordCredential)iterator.next();
            } else {
                try {
                    set = subject.getPrivateCredentials(PasswordCredential.class);
                    iterator = set.iterator();
                    if (iterator.hasNext()) {
                        passwordCredential = (PasswordCredential)iterator.next();
                    }
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
            }
        }
        set = null;
        boolean bl = compoundSecMechListImpl.hasGSSUP();
        boolean bl2 = compoundSecMechListImpl.hasGSSUPIdentity();
        if (bl) {
            object = compoundSecMechListImpl.getGSSUPTargetName();
            set = GSSUtil.extractGSSUPGSSNTExportedName((byte[])object);
        }
        if (bl && passwordCredential != null) {
            object = new InitialContextToken(passwordCredential.getUsername().getBytes("UTF8"), passwordCredential.getPassword().getBytes("UTF8"), compoundSecMechListImpl.getGSSUPTargetName());
            Any any = ORB.init().create_any();
            InitialContextTokenHelper.insert(any, (InitialContextToken)object);
            this.ctx.client_authentication_token = GSSUtil.getGSSUPToken(codec.encode_value(any));
            this.ctx.identity_token.absent(true);
        } else if (bl2) {
            if (subject == null) {
                this.ctx.identity_token.anonymous(true);
            } else {
                object = subject.getPrincipals(Principal.class);
                Iterator iterator = object.iterator();
                if (iterator.hasNext()) {
                    String string = ((Principal)iterator.next()).getName();
                    if (set != null) {
                        string = string + "@" + set;
                    }
                    byte[] byArray = GSSUtil.createGSSUPGSSNTExportedName(string);
                    this.ctx.identity_token.principal_name(byArray);
                }
            }
        }
    }

    public final EstablishContext getContext() {
        return this.ctx;
    }

    private static void p(String string) {
        System.out.println("<EstablishContextImpl>: " + string);
    }
}

