/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.security;

import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.iiop.IIOPAddress;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.legacy.connection.ORBSocketFactory;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.SocketInfo;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SSL_SEC_TRANS;
import org.omg.CSIIOP.SSL_SEC_TRANSHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedComponent;
import weblogic.corba.client.security.SSLEndPointInfo;
import weblogic.corba.j2ee.naming.ORBHelper;

public class SSLORBSocketFactory
implements ORBSocketFactory {
    private Hashtable epiCache = new Hashtable();
    protected static final boolean DEBUG = SSLORBSocketFactory.getDebug();
    private static final String proxyHost = SSLORBSocketFactory.getProxyHost();
    private static final int proxyPort = SSLORBSocketFactory.getProxyPort();

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.ssl");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static final String getProxyHost() {
        try {
            return System.getProperty("iiops.ProxyHost");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final int getProxyPort() {
        try {
            return Integer.getInteger("iiops.ProxyPort", 80);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public SSLORBSocketFactory() {
        if (DEBUG) {
            SSLORBSocketFactory.p("initialized");
        }
        boolean bl = false;
        try {
            String string = System.getProperty("weblogic.security.SSL.ignoreHostnameVerification");
            if (string != null && string.equalsIgnoreCase("false")) {
                bl = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            if (!bl) {
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String string, SSLSession sSLSession) {
                        return true;
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ServerSocket createServerSocket(String string, int n) throws IOException {
        if (DEBUG) {
            SSLORBSocketFactory.p("createServerSocket(" + string + ", " + n + ")");
        }
        if (string == "IIOP_SSL_WLS") {
            return SSLServerSocketFactory.getDefault().createServerSocket(n);
        }
        return ServerSocketFactory.getDefault().createServerSocket(n);
    }

    public SocketInfo getEndPointInfo(org.omg.CORBA.ORB oRB, IOR iOR, SocketInfo socketInfo) {
        if (DEBUG) {
            SSLORBSocketFactory.p("getEndPointInfo(" + iOR + ")");
        }
        if ((socketInfo = (SocketInfo)this.epiCache.get(iOR)) == null) {
            IIOPAddress iIOPAddress;
            block17: {
                SSLContext sSLContext = ORBHelper.getORBHelper().getSSLContext(oRB);
                if (DEBUG && sSLContext != null) {
                    SSLORBSocketFactory.p("getEndPointInfo() found SSLContext");
                }
                boolean bl = true;
                IIOPProfileTemplate iIOPProfileTemplate = (IIOPProfileTemplate)iOR.getProfile().getTaggedProfileTemplate();
                iIOPAddress = iIOPProfileTemplate.getPrimaryAddress();
                TaggedComponent[] taggedComponentArray = iIOPProfileTemplate.getIOPComponents((ORB)oRB, 33);
                if (taggedComponentArray.length == 0) {
                    taggedComponentArray = iIOPProfileTemplate.getIOPComponents((ORB)oRB, 20);
                    bl = false;
                }
                if (taggedComponentArray.length > 0) {
                    try {
                        CodecFactory codecFactory = CodecFactoryHelper.narrow((Object)oRB.resolve_initial_references("CodecFactory"));
                        Encoding encoding = new Encoding(0, 1, 2);
                        Codec codec = codecFactory.create_codec(encoding);
                        if (bl) {
                            if (DEBUG) {
                                SSLORBSocketFactory.p("found " + taggedComponentArray.length + " CompoundSecMechList components");
                            }
                            Any any = codec.decode_value(taggedComponentArray[0].component_data, CompoundSecMechListHelper.type());
                            CompoundSecMechList compoundSecMechList = CompoundSecMechListHelper.extract(any);
                            if (compoundSecMechList.mechanism_list != null) {
                                for (int i = 0; i < compoundSecMechList.mechanism_list.length; ++i) {
                                    TaggedComponent taggedComponent = compoundSecMechList.mechanism_list[i].transport_mech;
                                    if (taggedComponent.tag != 36) continue;
                                    any = codec.decode_value(taggedComponent.component_data, TLS_SEC_TRANSHelper.type());
                                    TLS_SEC_TRANS tLS_SEC_TRANS = TLS_SEC_TRANSHelper.extract(any);
                                    if (tLS_SEC_TRANS.addresses.length <= 0) continue;
                                    if (DEBUG) {
                                        SSLORBSocketFactory.p("found TAG_TLS_SEC_TRANS component " + tLS_SEC_TRANS.addresses[0].host_name + ":" + tLS_SEC_TRANS.addresses[0].port);
                                    }
                                    socketInfo = new SSLEndPointInfo(tLS_SEC_TRANS.addresses[0].host_name, tLS_SEC_TRANS.addresses[0].port, "IIOP_SSL_WLS", sSLContext);
                                }
                            }
                            break block17;
                        }
                        Any any = codec.decode_value(taggedComponentArray[0].component_data, SSL_SEC_TRANSHelper.type());
                        SSL_SEC_TRANS sSL_SEC_TRANS = SSL_SEC_TRANSHelper.extract(any);
                        if (DEBUG) {
                            SSLORBSocketFactory.p("found TAG_SSL_SEC_TRANS component " + sSL_SEC_TRANS.port);
                        }
                        socketInfo = new SSLEndPointInfo(iIOPAddress.getHost(), sSL_SEC_TRANS.port, "IIOP_SSL_WLS", sSLContext);
                    }
                    catch (UserException userException) {
                        if (DEBUG) {
                            userException.printStackTrace();
                            SSLORBSocketFactory.p("problem decoding TLS/SSL components in IOR");
                        }
                        break block17;
                    }
                }
                String string = new String(iOR.getProfile().getObjectKey().getId().getId());
                if (string.equals("NameService") || string.equals("INIT")) {
                    socketInfo = new SSLEndPointInfo(iIOPAddress.getHost(), iIOPAddress.getPort(), "IIOP_SSL_WLS", sSLContext);
                }
            }
            if (socketInfo == null) {
                socketInfo = new SSLEndPointInfo(iIOPAddress.getHost(), iIOPAddress.getPort(), "IIOP_CLEAR_TEXT", null);
                if (DEBUG) {
                    SSLORBSocketFactory.p("couldn't find TAG_TLS_SEC_TRANS component for " + iOR.getTypeId());
                }
            }
            this.epiCache.put(iOR, socketInfo);
        }
        return socketInfo;
    }

    public Socket createSocket(SocketInfo socketInfo) throws IOException {
        if (DEBUG) {
            SSLORBSocketFactory.p("createSocket(" + socketInfo.getHost() + ":" + socketInfo.getPort() + ", " + socketInfo.getType() + ")");
        }
        SocketFactory socketFactory = null;
        try {
            if (socketInfo.getType() == "IIOP_SSL_WLS") {
                socketFactory = ((SSLEndPointInfo)socketInfo).getContext() != null ? ((SSLEndPointInfo)socketInfo).getContext().getSocketFactory() : SSLSocketFactory.getDefault();
                if (proxyHost != null && proxyPort > 0) {
                    return SSLORBSocketFactory.createProxySSLSocket((SSLSocketFactory)socketFactory, socketInfo.getHost(), socketInfo.getPort(), proxyHost, proxyPort);
                }
            } else {
                socketFactory = SocketFactory.getDefault();
            }
            return socketFactory.createSocket(socketInfo.getHost(), socketInfo.getPort());
        }
        catch (IOException iOException) {
            if (DEBUG) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        catch (IllegalStateException illegalStateException) {
            if (DEBUG) {
                illegalStateException.printStackTrace();
            }
            throw illegalStateException;
        }
    }

    private static final Socket createProxySSLSocket(SSLSocketFactory sSLSocketFactory, String string, int n, String string2, int n2) throws IOException {
        Socket socket = SocketFactory.getDefault().createSocket(string2, n2);
        String string3 = new String("CONNECT " + string + ":" + n + " HTTP/1.1\r\n\r\n");
        if (DEBUG) {
            SSLORBSocketFactory.p("Proxy conect: " + string3);
        }
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(string3.getBytes());
        outputStream.flush();
        DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
        String string4 = dataInputStream.readLine();
        if (DEBUG) {
            SSLORBSocketFactory.p("Proxy response: " + string4);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string4);
        try {
            stringTokenizer.nextToken();
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            if (n3 < 200 || n3 > 299) {
                throw new ConnectException("HTTP error: " + n3);
            }
            if (DEBUG) {
                SSLORBSocketFactory.p("Proxy connected: " + n3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ConnectException("Bad HTTP response");
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConnectException("Bad HTTP response");
        }
        String string5 = null;
        while ((string5 = dataInputStream.readLine()).length() > 0) {
            if (!DEBUG) continue;
            SSLORBSocketFactory.p("Discarding: " + string5);
        }
        return sSLSocketFactory.createSocket(socket, string, n, true);
    }

    protected static void p(String string) {
        System.err.println("<SSLORBSocketFactory> " + string);
    }
}

