/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.utils;

import java.io.IOException;
import java.io.NotSerializableException;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.portable.InputStream;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextInput;

class ContextInputImpl
implements WorkContextInput {
    private InputStream delegate;

    ContextInputImpl(InputStream inputStream) {
        this.delegate = inputStream;
    }

    public String readASCII() throws IOException {
        return this.delegate.read_string();
    }

    public WorkContext readContext() throws IOException, ClassNotFoundException {
        Class clazz = Util.loadClass((String)this.readASCII(), null, null);
        try {
            WorkContext workContext = (WorkContext)clazz.newInstance();
            workContext.readContext(this);
            return workContext;
        }
        catch (InstantiationException instantiationException) {
            throw (IOException)new NotSerializableException("WorkContext must have a public no-arg constructor").initCause(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (IOException)new NotSerializableException("WorkContext must have a public no-arg constructor").initCause(illegalAccessException);
        }
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine");
    }

    public int readInt() throws IOException {
        return this.delegate.read_long();
    }

    public String readUTF() throws IOException {
        return this.delegate.read_wstring();
    }

    public long readLong() throws IOException {
        return this.delegate.read_longlong();
    }

    public byte readByte() throws IOException {
        return this.delegate.read_octet();
    }

    public short readShort() throws IOException {
        return this.delegate.read_short();
    }

    public float readFloat() throws IOException {
        return this.delegate.read_float();
    }

    public char readChar() throws IOException {
        return this.delegate.read_wchar();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.delegate.read_octet_array(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.delegate.read_octet_array(byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        throw new UnsupportedOperationException("skip()");
    }

    public boolean readBoolean() throws IOException {
        return this.delegate.read_boolean();
    }

    public int readUnsignedByte() throws IOException {
        return this.delegate.read_octet();
    }

    public int readUnsignedShort() throws IOException {
        return this.delegate.read_short();
    }

    public double readDouble() throws IOException {
        return this.delegate.read_double();
    }
}

