/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.utils;

import java.io.IOException;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import weblogic.corba.client.utils.ContextInputImpl;
import weblogic.corba.client.utils.ContextOutputImpl;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.spi.WorkContextMapInterceptor;

public final class ContextInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final boolean DEBUG = false;
    public static final int VENDOR_RUNTIME_CONTEXT = 1111834891;
    private final Codec codec;
    private final ORB orb;
    private final DynAnyFactory factory;

    public ContextInterceptor(Codec codec, DynAnyFactory dynAnyFactory) throws Exception {
        this.codec = codec;
        this.factory = dynAnyFactory;
        this.orb = ORB.init();
    }

    public String name() {
        return "ContextInterceptor";
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        ServiceContext serviceContext = this.encodeContexts();
        if (serviceContext != null) {
            clientRequestInfo.add_request_service_context(serviceContext, true);
        }
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
        this.decodeContexts(clientRequestInfo);
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) {
    }

    private final ServiceContext encodeContexts() {
        try {
            WorkContextMapInterceptor workContextMapInterceptor = WorkContextHelper.getWorkContextHelper().getLocalInterceptor();
            if (workContextMapInterceptor != null) {
                ContextOutputImpl contextOutputImpl = new ContextOutputImpl(this.orb, this.factory);
                workContextMapInterceptor.sendRequest(contextOutputImpl, 4);
                return new ServiceContext(1111834891, this.codec.encode_value(contextOutputImpl.get_any()));
            }
        }
        catch (InvalidTypeForEncoding invalidTypeForEncoding) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void decodeContexts(ClientRequestInfo clientRequestInfo) {
        WorkContextMapInterceptor workContextMapInterceptor = WorkContextHelper.getWorkContextHelper().getInterceptor();
        try {
            ServiceContext serviceContext = clientRequestInfo.get_reply_service_context(1111834891);
            OutputStream outputStream = this.orb.create_output_stream();
            outputStream.write_octet_array(serviceContext.context_data, 0, serviceContext.context_data.length);
            InputStream inputStream = outputStream.create_input_stream();
            inputStream.read_boolean();
            workContextMapInterceptor.receiveResponse(new ContextInputImpl(inputStream));
        }
        catch (BAD_PARAM bAD_PARAM) {
            if (bAD_PARAM.minor != 1330446362) {
                throw bAD_PARAM;
            }
            try {
                workContextMapInterceptor.receiveResponse(null);
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void p(String string) {
        System.err.println("<ContextInterceptor> " + string);
    }
}

