/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.utils;

import java.io.IOException;
import java.util.ArrayList;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.OutputStream;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynStructHelper;
import org.omg.DynamicAny.NameValuePair;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextOutput;

class ContextOutputImpl
implements WorkContextOutput {
    private ArrayList members = new ArrayList();
    private ORB orb;
    private DynAnyFactory factory;

    ContextOutputImpl(ORB oRB, DynAnyFactory dynAnyFactory) {
        this.orb = oRB;
        this.factory = dynAnyFactory;
    }

    Any get_any() throws InvalidTypeForEncoding {
        try {
            NameValuePair[] nameValuePairArray = this.members.toArray(new NameValuePair[0]);
            StructMember[] structMemberArray = new StructMember[nameValuePairArray.length];
            for (int i = 0; i < nameValuePairArray.length; ++i) {
                structMemberArray[i] = new StructMember("", nameValuePairArray[i].value.type(), null);
            }
            DynStruct dynStruct = DynStructHelper.narrow((Object)this.factory.create_dyn_any_from_type_code(this.orb.create_struct_tc("MyStruct", "MyStruct", structMemberArray)));
            dynStruct.set_members(nameValuePairArray);
            return dynStruct.to_any();
        }
        catch (TypeMismatch typeMismatch) {
            throw (InvalidTypeForEncoding)new InvalidTypeForEncoding().initCause((Throwable)typeMismatch);
        }
        catch (InvalidValue invalidValue) {
            throw (InvalidTypeForEncoding)new InvalidTypeForEncoding().initCause((Throwable)invalidValue);
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            throw (InvalidTypeForEncoding)new InvalidTypeForEncoding().initCause((Throwable)inconsistentTypeCode);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        Any any = this.orb.create_any();
        TypeCode typeCode = this.orb.create_array_tc(n2, this.orb.get_primitive_tc(TCKind.tk_octet));
        any.type(typeCode);
        OutputStream outputStream = any.create_output_stream();
        outputStream.write_octet_array(byArray, n, n2);
        any.read_value(outputStream.create_input_stream(), typeCode);
        this.members.add(new NameValuePair("", any));
    }

    public void write(int n) throws IOException {
        this.writeByte(n);
    }

    public void writeInt(int n) throws IOException {
        Any any = this.orb.create_any();
        any.insert_long(n);
        this.members.add(new NameValuePair("", any));
    }

    public void writeUTF(String string) throws IOException {
        Any any = this.orb.create_any();
        any.insert_wstring(string);
        this.members.add(new NameValuePair("", any));
    }

    public void writeLong(long l) throws IOException {
        Any any = this.orb.create_any();
        any.insert_longlong(l);
        this.members.add(new NameValuePair("", any));
    }

    public void writeByte(int n) throws IOException {
        this.write((byte)(n & 0xFF));
    }

    public void writeShort(int n) throws IOException {
        Any any = this.orb.create_any();
        any.insert_short((short)(n & 0xFFFF));
        this.members.add(new NameValuePair("", any));
    }

    public void writeBytes(String string) throws IOException {
        throw new UnsupportedOperationException("writeBytes()");
    }

    public void writeFloat(float f) throws IOException {
        Any any = this.orb.create_any();
        any.insert_float(f);
        this.members.add(new NameValuePair("", any));
    }

    public void writeChar(int n) throws IOException {
        Any any = this.orb.create_any();
        any.insert_wchar((char)(n & 0xFFFF));
        this.members.add(new NameValuePair("", any));
    }

    public void writeBoolean(boolean bl) throws IOException {
        Any any = this.orb.create_any();
        any.insert_boolean(bl);
        this.members.add(new NameValuePair("", any));
    }

    public void writeDouble(double d) throws IOException {
        Any any = this.orb.create_any();
        any.insert_double(d);
        this.members.add(new NameValuePair("", any));
    }

    public void writeChars(String string) throws IOException {
        throw new UnsupportedOperationException("writeChars()");
    }

    public void writeASCII(String string) throws IOException {
        Any any = this.orb.create_any();
        any.insert_string(string);
        this.members.add(new NameValuePair("", any));
    }

    public void writeContext(WorkContext workContext) throws IOException {
        try {
            this.writeASCII(workContext.getClass().getName());
            ContextOutputImpl contextOutputImpl = new ContextOutputImpl(this.orb, this.factory);
            workContext.writeContext(contextOutputImpl);
            Any any = contextOutputImpl.get_any();
            this.members.add(new NameValuePair("", any));
        }
        catch (InvalidTypeForEncoding invalidTypeForEncoding) {
            throw (IOException)new IOException(invalidTypeForEncoding.getMessage()).initCause(invalidTypeForEncoding);
        }
    }
}

