/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.security;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;

public class GSSUtil {
    private static final boolean DEBUG = false;
    static final byte[] encodedGSSNTOID = new byte[]{6, 6, 43, 6, 1, 5, 6, 4};
    static final byte[] encodedGSSUPOID = new byte[]{6, 6, 103, -127, 2, 1, 1, 1};

    public static byte[] createGSSUPGSSNTExportedName(String string) {
        byte[] byArray = string.getBytes();
        int n = 4 + encodedGSSUPOID.length + 4 + byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        byArray2[n2++] = 4;
        byArray2[n2++] = 1;
        byArray2[n2++] = (byte)(encodedGSSUPOID.length >>> 8);
        byArray2[n2++] = (byte)(encodedGSSUPOID.length >>> 0);
        System.arraycopy(encodedGSSUPOID, 0, byArray2, n2, encodedGSSUPOID.length);
        n2 += encodedGSSUPOID.length;
        byArray2[n2++] = (byte)(byArray.length >>> 24);
        byArray2[n2++] = (byte)(byArray.length >>> 16);
        byArray2[n2++] = (byte)(byArray.length >>> 8);
        byArray2[n2++] = (byte)(byArray.length >>> 0);
        System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
        return byArray2;
    }

    public static String extractGSSUPGSSNTExportedName(byte[] byArray) {
        int n = byArray.length;
        if (byArray[0] != 4 || byArray[1] != 1) {
            return null;
        }
        int n2 = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        if (n2 != encodedGSSUPOID.length) {
            return null;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 4, byArray2, 0, n2);
        if (!Arrays.equals(byArray2, encodedGSSUPOID)) {
            return null;
        }
        int n3 = 4 + encodedGSSUPOID.length;
        int n4 = (byArray[n3] & 0xFF) << 24 | (byArray[n3 + 1] & 0xFF) << 16 | (byArray[n3 + 2] & 0xFF) << 8 | byArray[n3 + 3] & 0xFF;
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray, n3 += 4, byArray3, 0, n4);
        return new String(byArray3);
    }

    public static byte[] getGSSUPMech() {
        return encodedGSSUPOID;
    }

    public static boolean isGSSUPMech(byte[] byArray) {
        return Arrays.equals(byArray, GSSUtil.getGSSUPMech());
    }

    public static byte[] getGSSUPToken(byte[] byArray) {
        byte[] byArray2 = GSSUtil.getGSSUPMech();
        int n = byArray2.length + byArray.length;
        int n2 = GSSUtil.getDERNumOctets(n);
        int n3 = 1 + n2 + byArray2.length + byArray.length;
        byte[] byArray3 = new byte[n3];
        int n4 = 0;
        byArray3[n4++] = 96;
        if (n < 128) {
            byArray3[n4++] = (byte)n;
        } else {
            byArray3[n4++] = (byte)(n2 + 127);
            switch (n2) {
                case 2: {
                    byArray3[n4++] = (byte)(n & 0xFF);
                    break;
                }
                case 3: {
                    byArray3[n4++] = (byte)(n >> 8 & 0xFF);
                    byArray3[n4++] = (byte)(n & 0xFF);
                    break;
                }
                case 4: {
                    byArray3[n4++] = (byte)(n >> 16 & 0xFF);
                    byArray3[n4++] = (byte)(n >> 8 & 0xFF);
                    byArray3[n4++] = (byte)(n & 0xFF);
                    break;
                }
                case 5: {
                    byArray3[n4++] = (byte)(n >> 24);
                    byArray3[n4++] = (byte)(n >> 16 & 0xFF);
                    byArray3[n4++] = (byte)(n >> 8 & 0xFF);
                    byArray3[n4++] = (byte)(n & 0xFF);
                }
            }
        }
        System.arraycopy(byArray2, 0, byArray3, n4, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, n4 += byArray2.length, byArray.length);
        return byArray3;
    }

    private static int getDERNumOctets(int n) {
        if (n < 128) {
            return 1;
        }
        if (n < 256) {
            return 2;
        }
        if (n < 65536) {
            return 3;
        }
        if (n < 0x1000000) {
            return 4;
        }
        return 5;
    }

    public static byte[] getGSSUPInnerToken(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = byArray.length;
        if (byArray.length < 6 || byArray[n2++] != 96) {
            return null;
        }
        int n4 = 0;
        if (byArray[n2] < 128 && byArray[n2] >= 0) {
            n4 = byArray[n2++];
        } else {
            n = byArray[n2++] & 0x7F;
            switch (n) {
                case 1: {
                    n4 = byArray[n2++] & 0xFF;
                    break;
                }
                case 2: {
                    n4 = byArray[n2++] << 8 & 0xFF00 | byArray[n2++] & 0xFF;
                    break;
                }
                case 3: {
                    n4 = byArray[n2++] << 16 & 0xFF0000 | byArray[n2++] << 8 & 0xFF00 | byArray[n2++] & 0xFF;
                    break;
                }
                case 4: {
                    n4 = byArray[n2++] << 24 & 0xFF000000 | byArray[n2++] << 16 & 0xFF0000 | byArray[n2++] << 8 & 0xFF00 | byArray[n2++] & 0xFF;
                }
            }
        }
        for (n = 0; n < encodedGSSUPOID.length; ++n) {
            if (n2 >= n3 || encodedGSSUPOID[n] != byArray[n2]) {
                return null;
            }
            ++n2;
        }
        byte[] byArray2 = new byte[n3 - n2];
        System.arraycopy(byArray, n2, byArray2, 0, n3 - n2);
        return byArray2;
    }

    public static X509Certificate[] getX509CertChain(byte[] byArray) {
        int n = 0;
        if (byArray == null || byArray.length < 2 || byArray[n++] != 48) {
            return null;
        }
        int n2 = 0;
        if (byArray[n] < 128 && byArray[n] >= 0) {
            n2 = byArray[n++];
        } else {
            int n3 = byArray[n++] & 0x7F;
            switch (n3) {
                case 1: {
                    n2 = byArray[n++] & 0xFF;
                    break;
                }
                case 2: {
                    n2 = byArray[n++] << 8 & 0xFF00 | byArray[n++] & 0xFF;
                    break;
                }
                case 3: {
                    n2 = byArray[n++] << 16 & 0xFF0000 | byArray[n++] << 8 & 0xFF00 | byArray[n++] & 0xFF;
                    break;
                }
                case 4: {
                    n2 = byArray[n++] << 24 & 0xFF000000 | byArray[n++] << 16 & 0xFF0000 | byArray[n++] << 8 & 0xFF00 | byArray[n++] & 0xFF;
                }
            }
        }
        if (n2 != byArray.length - n) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (byteArrayInputStream.available() > 0) {
                arrayList.add(certificateFactory.generateCertificate(byteArrayInputStream));
            }
        }
        catch (CertificateException certificateException) {
            return null;
        }
        return arrayList.toArray(new X509Certificate[arrayList.size()]);
    }

    private static void p(String string) {
        System.out.println("<GSSUtil>: " + string);
    }
}

