/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.iiop.http;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;

public final class TunnelUtils {
    private static final boolean DEBUG = TunnelUtils.getDebug();
    public static final String TUNNEL_SEND = "/bea_wls_internal/iiop/ClientSend";
    public static final String TUNNEL_RECV = "/bea_wls_internal/iiop/ClientRecv";
    public static final String TUNNEL_LOGIN = "/bea_wls_internal/iiop/ClientLogin";
    public static final String TUNNEL_CLOSE = "/bea_wls_internal/iiop/ClientClose";
    public static final int MSG_HEADER_LENGTH = 12;
    public static final String TUNNEL_OK = "OK";
    public static final String TUNNEL_DEAD = "DEAD";
    public static final String TUNNEL_RETRY = "RETRY";
    public static final String TUNNEL_UNAVAIL = "UNAVAIL";
    public static final String RESULT_HEADER = "WL-Result";
    public static final String TYPE_HEADER = "WL-Type";
    public static final String VERSION_HEADER = "WL-Version";
    public static final String ID_HEADER = "Conn-Id";
    public static final String CONNECT_PARAM_HEADER_LEN = "HL";
    public static final String DEST_HEADER = "WL-Dest";
    public static final String CLUSTER_LIST_HEADER = "WL-List";
    public static final String SCHEME_HEADER = "WL-Scheme";
    public static final String PARAM_CONNECTION_ID = "connectionID";
    public static final String PARAM_RAND = "rand";
    public static final String TUNNEL_COOKIE_NAME = "JSESSIONID";
    private static final Random rand = new Random(System.currentTimeMillis());

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.http.tunnelUtils");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static long getNextRandom() {
        return rand.nextLong() & Long.MAX_VALUE;
    }

    public static void drainStream(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            int n = 0;
            while ((n = inputStream.read()) != -1) {
            }
            inputStream.close();
        }
    }

    public static int toInt(int n) {
        return n & 0xFF;
    }

    public static void readConnectionParams(DataInputStream dataInputStream) throws IOException {
        int n = 12;
        String string = "";
        while ((string = dataInputStream.readLine()) != null && string.length() != 0) {
            if (string.charAt(0) != CONNECT_PARAM_HEADER_LEN.charAt(0) || string.charAt(1) != CONNECT_PARAM_HEADER_LEN.charAt(1)) continue;
            try {
                n = Integer.parseInt(string.substring(string.indexOf(58) + 1, string.length()));
            }
            catch (Exception exception) {
                throw new ProtocolException("Invalid parameter: " + string);
            }
        }
    }

    public static Properties getProperties(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(61) == -1) {
            return null;
        }
        Properties properties = new Properties();
        if (string.indexOf(44) == -1) {
            TunnelUtils.setProperty(properties, string);
            return properties;
        }
        String[] stringArray = TunnelUtils.splitCompletely(string, ",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(61) == -1) continue;
            TunnelUtils.setProperty(properties, stringArray[i]);
        }
        return properties;
    }

    public static void setCustomRequestProperties(Properties properties, URLConnection uRLConnection) {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                if (DEBUG) {
                    TunnelUtils.p("setRequestProperty(" + string + "," + string2 + ")");
                }
                uRLConnection.setRequestProperty(string, string2);
            }
        }
    }

    private static String[] splitCompletely(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private static final void p(String string) {
        System.out.println("<TunnelUtils>: " + string);
    }

    private static final void setProperty(Properties properties, String string) {
        String string2 = string.substring(0, string.indexOf(61));
        String string3 = string.substring(string.indexOf(61) + 1);
        if (DEBUG) {
            TunnelUtils.p("CustomHeader(" + string2 + "," + string3 + ")");
        }
        properties.setProperty(string2, string3);
    }

    public static final String getRequestArgs(String string) {
        return "?connectionID=" + string + "&rand=" + TunnelUtils.getNextRandom();
    }
}

