/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.naming;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import weblogic.corba.iiop.cluster.RandomSelector;
import weblogic.corba.iiop.cluster.RoundRobinSelector;
import weblogic.corba.iiop.cluster.Selector;
import weblogic.corba.j2ee.naming.EndPointInfo;

public final class NameParser
implements javax.naming.NameParser {
    public static final String IIOP_PROTOCOL = "iiop";
    public static final String TGIOP_PROTOCOL = "tgiop";
    public static final String COMPLEX_PROTOCOL = "complex";
    public static final String IIOPS_PROTOCOL = "iiops";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String TGIOP_PREFIX = "tgiop:";
    public static final String IIOP_PREFIX = "iiop:";
    public static final String T3_PREFIX = "t3:";
    public static final String T3S_PREFIX = "t3s:";
    public static final String IOR_PREFIX = "IOR:";
    public static final String IIOPS_PREFIX = "iiops:";
    public static final String IIOPLOC_PREFIX = "iioploc:";
    public static final String HTTP_PREFIX = "http:";
    public static final String HTTPS_PREFIX = "https:";
    public static final String CORBALOC_PREFIX = "corbaloc:";
    public static final String IIOPNAME_PREFIX = "iiopname:";
    public static final String CORBANAME_PREFIX = "corbaname:";
    public static final String NAME_SERVICE = "NameService";
    public static final boolean DEBUG = false;
    private static HashMap protocolMap = new HashMap();
    private static HashMap clientProtocolMap;
    public static final String CORBALOC_RIR_PREFIX = "corbaloc:rir:";
    public static final String CORBALOC_TGIOP_PREFIX = "corbaloc:tgiop:";
    public static final String CORBALOC_IIOP_PREFIX = "corbaloc:iiop:";
    public static final String CORBALOC_HTTP_PREFIX = "corbaloc:http:";
    public static final String CORBALOC_HTTPS_PREFIX = "corbaloc:https:";
    public static final String CORBALOC_IIOP_PREFIX2 = "corbaloc::";
    public static final String CORBALOC_IIOPS_PREFIX = "corbaloc:iiops:";
    public static final String CORBANAME_RIR_PREFIX = "corbaname:rir:";
    public static final String CORBANAME_TGIOP_PREFIX = "corbaname:tgiop:";
    public static final String CORBANAME_IIOP_PREFIX = "corbaname:iiop:";
    public static final String CORBANAME_IIOP_PREFIX2 = "corbaname::";
    public static final String CORBANAME_IIOPS_PREFIX = "corbaname:iiops:";
    private static HashMap complexProtocolMap;
    private static int defaultMinorVersion;
    private static final Properties defaultProps;

    public static void initialize(int n) {
        defaultMinorVersion = n;
    }

    public static boolean isGIOPProtocol(String string) {
        return NameParser.getProtocol(string) != null;
    }

    public Name parse(String string) throws NamingException {
        return NameParser.parseName(string);
    }

    public static Name parseName(String string) throws NamingException {
        return new CompoundName(string, defaultProps);
    }

    public static String getProtocol(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n + 1);
        String string3 = (String)protocolMap.get(string2);
        if (string3 == COMPLEX_PROTOCOL) {
            if ((n = string.indexOf(58, n + 1)) < 0) {
                return null;
            }
            string2 = string.substring(0, n + 1);
            string3 = (String)complexProtocolMap.get(string2);
        }
        return string3;
    }

    public static String getProtocolString(String string) throws InvalidNameException {
        if (NameParser.getProtocol(string) == null) {
            return null;
        }
        try {
            int n = string.indexOf(35);
            if (n >= 0) {
                return string.substring(0, n);
            }
            n = string.indexOf(47);
            if (n < 0) {
                return string;
            }
            int n2 = string.indexOf(47, n + 1);
            if (n2 < 0) {
                return string;
            }
            if (string.substring(n + 1, n2).equals(NAME_SERVICE)) {
                return string.substring(0, n2 + 1);
            }
            n = string.indexOf(47, n2 + 1);
            if (n < 0) {
                return string;
            }
            return string.substring(0, n + 1);
        }
        catch (Exception exception) {
            InvalidNameException invalidNameException = new InvalidNameException("Invalid scheme");
            invalidNameException.setRootCause(exception);
            throw invalidNameException;
        }
    }

    public static String getNameString(String string) {
        if (NameParser.getProtocol(string) == null) {
            return string;
        }
        int n = string.indexOf(35);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        n = string.indexOf(47);
        if (n < 0) {
            return "";
        }
        int n2 = string.indexOf(47, n + 1);
        if (n2 < 0) {
            return "";
        }
        if (string.substring(n + 1, n2).equals(NAME_SERVICE)) {
            return string.substring(n2 + 1);
        }
        n = string.indexOf(47, n2 + 1);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static URLInfo parseURL(String string) throws InvalidNameException {
        if (string == null) {
            throw new InvalidNameException("url is null");
        }
        int n = string.indexOf(58);
        String string2 = string.substring(0, n + 1);
        String string3 = (String)clientProtocolMap.get(string2);
        if (string3 == COMPLEX_PROTOCOL) {
            return NameParser.parseComplexURL(string);
        }
        if (string3 == null) {
            return null;
        }
        URLInfo uRLInfo = new URLInfo(string3);
        String string4 = string.substring(n + 1);
        if (!string4.startsWith("//")) {
            throw new InvalidNameException("url does not contain //");
        }
        string4 = string4.substring(2);
        int n2 = 0;
        ArrayList<EndPointInfo> arrayList = null;
        while (n2 >= 0) {
            n2 = string4.indexOf(44);
            if (n2 < 0 && (n2 = string4.indexOf(124)) >= 0) {
                uRLInfo.selector = RandomSelector.SELECTOR;
            }
            String string5 = string4;
            if (n2 >= 0) {
                string5 = string4.substring(0, n2);
                string4 = string4.substring(n2 + 1);
            }
            String string6 = string5;
            int n3 = -1;
            if (string3 != TGIOP_PROTOCOL) {
                n = string5.lastIndexOf(58);
                if (n < 0) {
                    n = string4.indexOf(58);
                    if (n < 0) {
                        throw new InvalidNameException("url does not contain a port");
                    }
                    string6 = string5;
                    string5 = string4;
                } else {
                    string6 = string5.substring(0, n);
                }
                int n4 = string5.indexOf(47);
                if (n4 < 0) {
                    n4 = string5.length();
                }
                try {
                    n3 = Integer.parseInt(string5.substring(n + 1, n4));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (string5.length() > n4) {
                    uRLInfo.name = string5.substring(n4);
                }
            }
            uRLInfo.addressList[0] = new EndPointInfo(string6, n3, 1, defaultMinorVersion);
            if (n2 <= 0 && arrayList == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<EndPointInfo>();
            }
            arrayList.add(uRLInfo.addressList[0]);
        }
        if (arrayList != null) {
            uRLInfo.addressList = arrayList.toArray(uRLInfo.addressList);
            uRLInfo.randomizeStart();
        } else {
            NameParser.normalizeClusterAddress(uRLInfo);
        }
        return uRLInfo;
    }

    private static void normalizeClusterAddress(URLInfo uRLInfo) throws InvalidNameException {
    }

    public static URLInfo parseComplexURL(String string) throws InvalidNameException {
        if (string == null) {
            throw new InvalidNameException("url is null");
        }
        int n = string.indexOf(58);
        if (n < 0) {
            throw new InvalidNameException("url does not contain :");
        }
        if ((n = string.indexOf(58, n + 1)) < 0) {
            throw new InvalidNameException("url does not contain ::");
        }
        String string2 = string.substring(0, n + 1);
        String string3 = (String)complexProtocolMap.get(string2);
        if (string3 == null) {
            throw new InvalidNameException("url does not contain a known protocol");
        }
        URLInfo uRLInfo = new URLInfo(string3);
        String string4 = string.substring(n + 1);
        if (string.startsWith(CORBANAME_PREFIX)) {
            n = string4.indexOf(35);
            if (n >= 0) {
                uRLInfo.name = string4.substring(n + 1);
            } else {
                n = string4.length();
            }
        } else if (string.startsWith(CORBALOC_PREFIX)) {
            n = string4.indexOf(47);
            if (n < 0) {
                throw new InvalidNameException("url does not contain a service name");
            }
            String string5 = string4.substring(n + 1);
            int n2 = string5.indexOf(47);
            if (n2 >= 0) {
                uRLInfo.serviceName = string5.substring(0, n2);
                uRLInfo.name = string5.substring(n2 + 1);
            } else {
                uRLInfo.serviceName = string5;
            }
        }
        string4 = string4.substring(0, n);
        int n3 = 0;
        ArrayList<EndPointInfo> arrayList = null;
        while (n3 >= 0) {
            String string6;
            int n4 = defaultMinorVersion;
            int n5 = 1;
            n3 = string4.indexOf(44);
            if (n3 < 0 && (n3 = string4.indexOf(124)) >= 0) {
                uRLInfo.selector = RandomSelector.SELECTOR;
            }
            String string7 = string4;
            if (n3 >= 0) {
                string7 = string4.substring(0, n3);
                try {
                    string4 = string4.substring(n3 + 1);
                    string4 = string4.substring(string4.indexOf(58) + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new InvalidNameException("url contains an Invalid multi-url specification");
                }
            }
            try {
                if (string7.indexOf(64) != -1) {
                    string6 = string7.substring(0, string7.indexOf(64));
                    string7 = string7.substring(string7.indexOf(64) + 1);
                    n5 = Integer.parseInt(string6.substring(0, 1));
                    n4 = Integer.parseInt(string6.substring(2, 3));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidNameException("url contains an invalid version specification");
            }
            string6 = string7;
            int n6 = -1;
            if (string3 != TGIOP_PROTOCOL) {
                n = string7.lastIndexOf(58);
                if (n < 0) {
                    throw new InvalidNameException("url does not contain :");
                }
                string6 = string7.substring(0, n);
                try {
                    n6 = Integer.parseInt(string7.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            uRLInfo.addressList[0] = new EndPointInfo(string6, n6, n5, n4);
            if (n3 <= 0 && arrayList == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<EndPointInfo>();
            }
            arrayList.add(uRLInfo.addressList[0]);
        }
        if (arrayList != null) {
            uRLInfo.addressList = arrayList.toArray(uRLInfo.addressList);
            uRLInfo.randomizeStart();
        } else {
            NameParser.normalizeClusterAddress(uRLInfo);
        }
        return uRLInfo;
    }

    public static void main(String[] stringArray) throws InvalidNameException {
        if (stringArray.length == 1) {
            String string = stringArray[0];
            System.out.println(NameParser.parseURL(string));
        } else {
            System.out.println("NameParser <url>");
        }
    }

    private static void p(String string) {
        System.out.println("<NameParser> " + string);
    }

    static {
        protocolMap.put(IIOPS_PREFIX, IIOPS_PROTOCOL);
        protocolMap.put(IIOP_PREFIX, IIOP_PROTOCOL);
        protocolMap.put(IOR_PREFIX, IIOP_PROTOCOL);
        protocolMap.put(TGIOP_PREFIX, TGIOP_PROTOCOL);
        protocolMap.put(IIOPLOC_PREFIX, IIOP_PROTOCOL);
        protocolMap.put(IIOPNAME_PREFIX, IIOP_PROTOCOL);
        protocolMap.put(CORBALOC_PREFIX, COMPLEX_PROTOCOL);
        protocolMap.put(CORBANAME_PREFIX, COMPLEX_PROTOCOL);
        clientProtocolMap = new HashMap(protocolMap);
        clientProtocolMap.put(T3S_PREFIX, IIOPS_PROTOCOL);
        clientProtocolMap.put(T3_PREFIX, IIOP_PROTOCOL);
        clientProtocolMap.put(HTTP_PREFIX, HTTP_PROTOCOL);
        clientProtocolMap.put(HTTPS_PREFIX, HTTPS_PROTOCOL);
        complexProtocolMap = new HashMap();
        complexProtocolMap.put(CORBALOC_RIR_PREFIX, IIOP_PROTOCOL);
        complexProtocolMap.put(CORBALOC_TGIOP_PREFIX, TGIOP_PROTOCOL);
        complexProtocolMap.put(CORBALOC_IIOP_PREFIX, IIOP_PROTOCOL);
        complexProtocolMap.put(CORBALOC_IIOP_PREFIX2, IIOP_PROTOCOL);
        complexProtocolMap.put(CORBALOC_IIOPS_PREFIX, IIOPS_PROTOCOL);
        complexProtocolMap.put(CORBALOC_HTTP_PREFIX, HTTP_PROTOCOL);
        complexProtocolMap.put(CORBALOC_HTTPS_PREFIX, HTTPS_PROTOCOL);
        complexProtocolMap.put(CORBANAME_RIR_PREFIX, IIOP_PROTOCOL);
        complexProtocolMap.put(CORBANAME_TGIOP_PREFIX, TGIOP_PROTOCOL);
        complexProtocolMap.put(CORBANAME_IIOP_PREFIX, IIOP_PROTOCOL);
        complexProtocolMap.put(CORBANAME_IIOP_PREFIX2, IIOP_PROTOCOL);
        complexProtocolMap.put(CORBANAME_IIOPS_PREFIX, IIOPS_PROTOCOL);
        defaultMinorVersion = 2;
        defaultProps = new Properties();
        defaultProps.put("jndi.syntax.direction", "left_to_right");
        defaultProps.put("jndi.syntax.separator", "/");
        defaultProps.put("jndi.syntax.separator2", ".");
        defaultProps.put("jndi.syntax.ignorecase", "false");
        defaultProps.put("jndi.syntax.escape", "\\");
        defaultProps.put("jndi.syntax.beginquote", "\"");
        defaultProps.put("jndi.syntax.endquote", "\"");
        defaultProps.put("jndi.syntax.beginquote2", "'");
        defaultProps.put("jndi.syntax.endquote2", "'");
        defaultProps.put("jndi.syntax.separator.ava", ",");
        defaultProps.put("jndi.syntax.separator.typeval", "=");
    }

    public static class URLInfo {
        private Selector selector = RoundRobinSelector.SELECTOR;
        private int current = 0;
        public EndPointInfo[] addressList;
        public String name = "";
        public String serviceName = "NameService";
        public String protocol = null;

        public URLInfo(String string) {
            this.protocol = string;
            this.addressList = new EndPointInfo[]{new EndPointInfo()};
        }

        public final String getHost() {
            return this.addressList[this.current].getHost();
        }

        public final int getPort() {
            return this.addressList[this.current].getPort();
        }

        public final int getMinorVersion() {
            return this.addressList[this.current].getMinorVersion();
        }

        public final int getMajorVersion() {
            return this.addressList[this.current].getMajorVersion();
        }

        public final EndPointInfo getAddress() {
            return this.addressList[this.current];
        }

        public final EndPointInfo getNextAddress() {
            EndPointInfo endPointInfo = this.addressList[this.current];
            this.current = this.selector.select(this.current, this.addressList.length);
            return endPointInfo;
        }

        public final String getService() {
            return this.serviceName;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        void randomizeStart() {
            if (this.addressList == null || this.addressList.length <= 1) {
                this.current = 0;
            } else {
                double d = Math.random() * (double)this.addressList.length + 0.5;
                this.current = (int)Math.round(d) - 1;
            }
        }

        final String getKey() {
            return this.protocol + this.getAddress().getAddress();
        }

        final String getNextKey() {
            return this.protocol + this.getNextAddress().getAddress();
        }

        public String getURL() {
            return NameParser.CORBALOC_PREFIX + this.protocol + ":" + this.addressList[this.current].getAddress() + "/" + this.serviceName;
        }

        public String getClusterURL() {
            StringBuffer stringBuffer = new StringBuffer(this.protocol + "://");
            for (int i = 0; i < this.addressList.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.addressList[i].getAddress());
            }
            return stringBuffer.toString();
        }

        public String getNeutralURL() {
            return NameParser.CORBALOC_IIOP_PREFIX2 + this.addressList[this.current].getAddress() + "/" + this.serviceName;
        }

        public boolean isSecure() {
            return this.protocol == NameParser.IIOPS_PROTOCOL;
        }

        public String toString() {
            return this.getURL() + (this.name.length() == 0 ? "" : "/" + this.name);
        }
    }
}

