/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.naming;

import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import weblogic.corba.cos.naming.NamingContextAnyHelper;
import weblogic.corba.cos.naming.NamingContextAnyPackage.CannotProceed;
import weblogic.corba.cos.naming.NamingContextAnyPackage.NotFound;
import weblogic.corba.cos.naming.NamingContextAnyPackage.WNameComponent;
import weblogic.corba.j2ee.naming.NameParser;

public final class Utils {
    private static final boolean DEBUG = false;

    public static NamingException wrapNamingException(Exception exception, String string) throws NamingException {
        NamingException namingException = null;
        if (exception instanceof InvalidName) {
            namingException = new InvalidNameException(string);
        } else if (exception instanceof org.omg.CORBA.ORBPackage.InvalidName) {
            namingException = new InvalidNameException(string);
        } else if (exception instanceof org.omg.CosNaming.NamingContextPackage.NotFound) {
            org.omg.CosNaming.NamingContextPackage.NotFound notFound = (org.omg.CosNaming.NamingContextPackage.NotFound)exception;
            string = string + ": `" + Utils.nameComponentToString(notFound.rest_of_name) + "'" + Utils.notFoundReasonToString(notFound.why);
            namingException = new NameNotFoundException(string);
        } else if (exception instanceof NotFound) {
            NotFound notFound = (NotFound)((java.lang.Object)exception);
            string = string + ": `" + Utils.nameComponentToString(notFound.rest_of_name) + "'" + Utils.notFoundReasonToString(notFound.why);
            namingException = new NameNotFoundException(string);
        } else if (exception instanceof org.omg.CosNaming.NamingContextPackage.CannotProceed) {
            org.omg.CosNaming.NamingContextPackage.CannotProceed cannotProceed = (org.omg.CosNaming.NamingContextPackage.CannotProceed)exception;
            string = string + ": unresolved name `" + Utils.nameComponentToString(cannotProceed.rest_of_name) + "'";
            namingException = new CannotProceedException(string);
        } else if (exception instanceof CannotProceed) {
            CannotProceed cannotProceed = (CannotProceed)((java.lang.Object)exception);
            string = string + ": unresolved name `" + Utils.nameComponentToString(cannotProceed.rest_of_name) + "'";
            namingException = new CannotProceedException(string);
        } else {
            namingException = exception instanceof AlreadyBound ? new NameAlreadyBoundException(string) : new NamingException(string);
        }
        namingException.setRootCause(exception);
        return namingException;
    }

    public static SystemException unwrapNamingException(SystemException systemException, NamingException namingException) {
        if (namingException.getRootCause() instanceof SystemException) {
            return (SystemException)namingException.getRootCause();
        }
        systemException.initCause((Throwable)namingException);
        return systemException;
    }

    public static SystemException initCORBAExceptionWithCause(SystemException systemException, Throwable throwable) {
        systemException.initCause(throwable);
        return systemException;
    }

    public static final NamingContext narrowContext(Object object) {
        if (object._is_a(NamingContextAnyHelper.id())) {
            return NamingContextAnyHelper.narrow(object);
        }
        return NamingContextHelper.narrow((Object)object);
    }

    public static final NameComponent[] stringToNameComponent(String string) throws NamingException {
        return Utils.nameToName(Utils.stringToName(string));
    }

    public static final Name stringToName(String string) throws NamingException {
        string = NameParser.getNameString(string);
        CompositeName compositeName = new CompositeName();
        while (string.length() > 0) {
            compositeName.add(Utils.getPrefix(string));
            string = Utils.getSuffix(string);
        }
        return compositeName;
    }

    public static final WNameComponent[] stringToWNameComponent(String string) throws NamingException {
        return Utils.nameToWName(Utils.stringToNameComponent(string));
    }

    public static final WNameComponent[] nameToWName(NameComponent[] nameComponentArray) throws NamingException {
        WNameComponent[] wNameComponentArray = new WNameComponent[nameComponentArray.length];
        for (int i = 0; i < nameComponentArray.length; ++i) {
            wNameComponentArray[i] = new WNameComponent(nameComponentArray[i].id, nameComponentArray[i].kind);
        }
        return wNameComponentArray;
    }

    public static final WNameComponent[] nameToWName(Name name) throws NamingException {
        WNameComponent[] wNameComponentArray = new WNameComponent[name.size()];
        for (int i = 0; i < name.size(); ++i) {
            wNameComponentArray[i] = new WNameComponent(name.get(i), "");
        }
        return wNameComponentArray;
    }

    public static final NameComponent[] nameToName(Name name) throws NamingException {
        NameComponent[] nameComponentArray = new NameComponent[name.size()];
        for (int i = 0; i < name.size(); ++i) {
            nameComponentArray[i] = new NameComponent(name.get(i), "");
        }
        return nameComponentArray;
    }

    public static final String nameComponentToString(NameComponent[] nameComponentArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (nameComponentArray != null) {
            for (int i = 0; i < nameComponentArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append('/');
                }
                String string = nameComponentArray[i].id;
                for (int j = 0; j < string.length(); ++j) {
                    if (j != 0 && j != string.length() - 1 && Utils.isQuote(string.charAt(j)) || Utils.isSeparator(string.charAt(j))) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(string.charAt(j));
                }
                if (nameComponentArray[i].kind.length() <= 0) continue;
                stringBuffer.append('/').append(nameComponentArray[i].kind);
            }
        }
        return stringBuffer.toString();
    }

    private static boolean isSeparator(char c) {
        return c == '.' || c == '/';
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    public static final String nameComponentToString(WNameComponent[] wNameComponentArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (wNameComponentArray != null) {
            for (int i = 0; i < wNameComponentArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append('/');
                }
                String string = wNameComponentArray[i].id;
                for (int j = 0; j < string.length(); ++j) {
                    if (j != 0 && j != string.length() - 1 && Utils.isQuote(string.charAt(j)) || Utils.isSeparator(string.charAt(j))) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(string.charAt(j));
                }
                if (wNameComponentArray[i].kind.length() <= 0) continue;
                stringBuffer.append('/').append(wNameComponentArray[i].kind);
            }
        }
        return stringBuffer.toString();
    }

    private static final String notFoundReasonToString(NotFoundReason notFoundReason) {
        switch (notFoundReason.value()) {
            case 0: {
                return " could not be found.";
            }
            case 1: {
                return " is not a naming context.";
            }
            case 2: {
                return " is not a remote object.";
            }
        }
        return null;
    }

    private static String getPrefix(String string) throws NamingException {
        if (string.length() == 0) {
            return string;
        }
        if (string.charAt(0) == '\"') {
            int n = string.indexOf(34, 1);
            if (n < 0) {
                throw new InvalidNameException("No closing quote");
            }
            if (n < string.length() - 1 && !Utils.isSeparator(string.charAt(n + 1))) {
                throw new InvalidNameException("Closing quote must be at component end");
            }
            return string.substring(1, n);
        }
        if (string.charAt(0) == '\'') {
            int n = string.indexOf(39, 1);
            if (n < 0) {
                throw new InvalidNameException("No closing quote");
            }
            if (n < string.length() - 1 && !Utils.isSeparator(string.charAt(n + 1))) {
                throw new InvalidNameException("Closing quote must be at component end");
            }
            return string.substring(1, n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\\': {
                    if (++i == string.length()) {
                        throw new InvalidNameException("An escape at the end of a name must be escaped");
                    }
                    stringBuffer.append(string.charAt(i));
                    continue block4;
                }
                case '\"': 
                case '\'': {
                    throw new InvalidNameException("Unescaped quote in a component");
                }
                default: {
                    if (Utils.isSeparator(string.charAt(i))) {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String getSuffix(String string) throws NamingException {
        if (string.length() == 0) {
            return string;
        }
        if (string.charAt(0) == '\"') {
            int n = string.indexOf(34, 1);
            if (n < 0) {
                throw new InvalidNameException("No closing quote");
            }
            if (n < string.length() - 1 && !Utils.isSeparator(string.charAt(n + 1))) {
                throw new InvalidNameException("Closing quote must be at component end");
            }
            if (++n < string.length() && Utils.isSeparator(string.charAt(n))) {
                ++n;
            }
            return string.substring(n);
        }
        if (string.charAt(0) == '\'') {
            int n = string.indexOf(39, 1);
            if (n < 0) {
                throw new InvalidNameException("No closing quote");
            }
            if (n < string.length() - 1 && !Utils.isSeparator(string.charAt(n + 1))) {
                throw new InvalidNameException("Closing quote must be at component end");
            }
            if (++n < string.length() && Utils.isSeparator(string.charAt(n))) {
                ++n;
            }
            return string.substring(n);
        }
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\\': {
                    if (++i != string.length()) continue block4;
                    throw new InvalidNameException("An escape at the end of a name must be escaped");
                }
                case '\"': 
                case '\'': {
                    throw new InvalidNameException("Unescaped quote in a component");
                }
                default: {
                    if (!Utils.isSeparator(string.charAt(i))) continue block4;
                    return string.substring(i + 1);
                }
            }
        }
        return "";
    }
}

