/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.Arrays;

public final class MarshalledObject
implements Serializable {
    private byte[] objBytes = null;
    private int hash;

    public MarshalledObject(Object object) throws IOException {
        if (object == null) {
            this.hash = 13;
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MarshalledObjectOutputStream marshalledObjectOutputStream = new MarshalledObjectOutputStream(byteArrayOutputStream);
        marshalledObjectOutputStream.writeObject(object);
        marshalledObjectOutputStream.flush();
        this.objBytes = byteArrayOutputStream.toByteArray();
        int n = 0;
        for (int i = 0; i < this.objBytes.length; ++i) {
            n = 31 * n + this.objBytes[i];
        }
        this.hash = n;
    }

    public Object readResolve() throws IOException, ClassNotFoundException, ObjectStreamException {
        if (this.objBytes == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.objBytes);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof MarshalledObject) {
            MarshalledObject marshalledObject = (MarshalledObject)object;
            if (this.objBytes == null || marshalledObject.objBytes == null) {
                return this.objBytes == marshalledObject.objBytes;
            }
            if (Arrays.equals(this.objBytes, marshalledObject.objBytes)) {
                return true;
            }
        }
        return false;
    }

    private static class MarshalledObjectOutputStream
    extends ObjectOutputStream {
        MarshalledObjectOutputStream(OutputStream outputStream) throws IOException {
            super(outputStream);
            this.enableReplaceObject(true);
        }

        public Object replaceObject(Object object) throws IOException {
            if (object instanceof Remote) {
                throw new NotSerializableException("marshal remote object - " + object.getClass().getName());
            }
            return object;
        }
    }
}

