/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.context;

import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextImpl;
import weblogic.kernel.KernelStatus;
import weblogic.workarea.PropertyReadOnlyException;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextMap;

public final class DiagnosticContextFactory {
    private static boolean contextEnabled;
    private static int propagationMode;

    static boolean isEnabled() {
        return contextEnabled;
    }

    static void setEnabled(boolean bl) {
        contextEnabled = bl;
    }

    static int getPropagationMode() {
        return propagationMode;
    }

    static void setPropagationMode(int n) {
        propagationMode = n;
    }

    public static DiagnosticContext getDiagnosticContext() {
        WorkContextMap workContextMap = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
        return (DiagnosticContext)workContextMap.get("weblogic.diagnostics.DiagnosticContext");
    }

    public static DiagnosticContext findOrCreateDiagnosticContext() {
        return DiagnosticContextFactory.findOrCreateDiagnosticContext(contextEnabled);
    }

    public static DiagnosticContext findOrCreateDiagnosticContext(boolean bl) {
        if (!KernelStatus.isServer()) {
            bl = true;
        }
        DiagnosticContext diagnosticContext = null;
        WorkContextMap workContextMap = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
        diagnosticContext = (DiagnosticContext)workContextMap.get("weblogic.diagnostics.DiagnosticContext");
        if (diagnosticContext == null && bl) {
            diagnosticContext = new DiagnosticContextImpl();
            try {
                workContextMap.put("weblogic.diagnostics.DiagnosticContext", diagnosticContext, propagationMode);
            }
            catch (PropertyReadOnlyException propertyReadOnlyException) {
                // empty catch block
            }
        }
        return diagnosticContext;
    }

    static {
        propagationMode = 127;
    }
}

