/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.context;

import java.io.IOException;
import java.rmi.dgc.VMID;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.InvalidDyeException;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextOutput;

public final class DiagnosticContextImpl
implements DiagnosticContext {
    private static final char[] int2hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int SEQID_LENGTH = 16;
    private static long seqID = 0L;
    private static final char[] baseID = DiagnosticContextImpl.createBaseID();
    private String contextId;
    private long dyeVector;
    private String payload;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagnosticContextImpl() {
        long l = 0L;
        char[] cArray = baseID;
        synchronized (baseID) {
            l = ++seqID;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            int n = baseID.length;
            int n2 = n + 16;
            char[] cArray2 = new char[n2];
            System.arraycopy(baseID, 0, cArray2, 0, n);
            for (int i = n2 - 1; i >= n; --i) {
                cArray2[i] = int2hex[(int)(l & 0xFL)];
                l >>= 4;
            }
            this.contextId = new String(cArray2);
            return;
        }
    }

    private static char[] createBaseID() {
        VMID vMID = new VMID();
        String string = vMID.toString() + "-";
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return cArray;
    }

    public String getContextId() {
        return this.contextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDye(byte by, boolean bl) throws InvalidDyeException {
        if (by < 0 || by > 63) {
            throw new InvalidDyeException("Invalid dye index " + by);
        }
        long l = 1L << by;
        DiagnosticContextImpl diagnosticContextImpl = this;
        synchronized (diagnosticContextImpl) {
            this.dyeVector = bl ? (this.dyeVector |= l) : (this.dyeVector &= l ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public boolean isDyedWith(byte by) throws InvalidDyeException {
        if (by < 0 || by > 63) {
            throw new InvalidDyeException("Invalid dye index " + by);
        }
        return (this.dyeVector & 1L << by) != 0L;
    }

    public void setDyeVector(long l) {
        this.dyeVector = l;
    }

    public long getDyeVector() {
        return this.dyeVector;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String string) {
        this.payload = string;
    }

    public void writeContext(WorkContextOutput workContextOutput) throws IOException {
        workContextOutput.writeASCII(this.contextId);
        workContextOutput.writeLong(this.dyeVector);
        if (this.payload != null) {
            workContextOutput.writeBoolean(true);
            workContextOutput.writeASCII(this.payload);
        } else {
            workContextOutput.writeBoolean(false);
        }
    }

    public void readContext(WorkContextInput workContextInput) throws IOException {
        this.contextId = workContextInput.readASCII();
        this.dyeVector = workContextInput.readLong();
        this.payload = workContextInput.readBoolean() ? workContextInput.readASCII() : null;
    }
}

