/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.debug;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import weblogic.diagnostics.debug.DebugContext;
import weblogic.diagnostics.debug.DebugLoggerRepository;

public final class DebugLogger {
    private static ThreadLocal recursionState = new ThreadLocal(){

        public Object initialValue() {
            return Boolean.FALSE;
        }
    };
    static final int CTX_MODE_OFF = 0;
    static final int CTX_MODE_AND = 1;
    static final int CTX_MODE_OR = 2;
    private static DebugLoggerRepository defaultRepository = new DebugLoggerRepository();
    private static Logger myLogger = DebugLogger.createAndInitAnonymousLogger();
    private static DebugContext debugContext = null;
    private static int contextMode = 0;
    private static long debugMask = 0L;
    private String debugLoggerName = null;
    private String displayName = null;
    private boolean debugEnabled = false;

    public static DebugLoggerRepository getDefaultDebugLoggerRepository() {
        return defaultRepository;
    }

    public static DebugLogger getDebugLogger(String string) {
        return defaultRepository.getDebugLogger(string);
    }

    public static DebugLogger createUnregisteredDebugLogger(String string, boolean bl) {
        DebugLogger debugLogger = new DebugLogger(string);
        debugLogger.setDebugEnabled(bl);
        return debugLogger;
    }

    static Logger getLogger() {
        return myLogger;
    }

    static void setLogger(Logger logger) {
        myLogger = logger;
    }

    static void setContextMode(int n) {
        contextMode = n;
    }

    static void setDebugContext(DebugContext debugContext) {
        DebugLogger.debugContext = debugContext;
    }

    static void setDebugMask(long l) {
        debugMask = l;
    }

    private static Logger createAndInitAnonymousLogger() {
        Logger logger = Logger.getAnonymousLogger();
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.FINE);
        StreamHandler streamHandler = new StreamHandler(System.out, new SimpleFormatter()){

            public void publish(LogRecord logRecord) {
                super.publish(logRecord);
                super.flush();
            }

            public void close() {
                super.flush();
            }
        };
        try {
            streamHandler.setLevel(Level.FINE);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        logger.addHandler(streamHandler);
        return logger;
    }

    DebugLogger(String string) {
        this.debugLoggerName = string;
        this.displayName = this.debugLoggerName.replaceFirst("Debug", "");
    }

    public String getDebugLoggerName() {
        return this.debugLoggerName;
    }

    public final boolean isDebugEnabled() {
        switch (contextMode) {
            case 1: {
                return this.debugEnabled && (debugMask & this.getDyeVector()) == debugMask;
            }
            case 2: {
                return this.debugEnabled && (debugMask & this.getDyeVector()) != 0L;
            }
        }
        return this.debugEnabled;
    }

    final void setDebugEnabled(boolean bl) {
        this.debugEnabled = bl;
    }

    public void debug(String string) {
        this.log(Level.FINE, string, null);
    }

    public void debug(String string, Throwable throwable) {
        this.log(Level.FINE, string, throwable);
    }

    private void log(Level level, String string, Throwable throwable) {
        if (this.isDebugEnabled()) {
            LogRecord logRecord = new LogRecord(level, string);
            logRecord.setLoggerName(this.displayName);
            logRecord.setThrown(throwable);
            logRecord.setSourceClassName(DebugLogger.class.getName());
            logRecord.setSourceMethodName("debug");
            myLogger.log(logRecord);
        }
    }

    private long getDyeVector() {
        long l = 0L;
        Boolean bl = (Boolean)recursionState.get();
        if (bl == Boolean.FALSE) {
            recursionState.set(Boolean.TRUE);
            l = debugContext.getDyeVector();
            recursionState.set(Boolean.FALSE);
        }
        return l;
    }
}

