/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.debug;

import java.util.HashMap;
import java.util.Map;
import weblogic.diagnostics.debug.DebugLogger;

public final class DebugLoggerRepository {
    private static final String DEFAULT_CMDLINE_OVERRIDE_PREFIX = "weblogic.debug.";
    private Map debugLoggers = new HashMap();
    private String cmdlineOveridePrifix;

    DebugLoggerRepository() {
        this(DEFAULT_CMDLINE_OVERRIDE_PREFIX);
    }

    DebugLoggerRepository(String string) {
        this.cmdlineOveridePrifix = string;
    }

    public synchronized DebugLogger getDebugLogger(String string) {
        DebugLogger debugLogger = (DebugLogger)this.debugLoggers.get(string);
        if (debugLogger == null) {
            debugLogger = new DebugLogger(string);
            this.debugLoggers.put(string, debugLogger);
            try {
                boolean bl = Boolean.getBoolean(this.cmdlineOveridePrifix + string);
                debugLogger.setDebugEnabled(bl);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return debugLogger;
    }
}

