/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import weblogic.kernel.AuditableThread;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.ThreadLocalInitialValue;
import weblogic.kernel.ThreadStorage;

final class FinalThreadLocal
implements AuditableThreadLocal {
    private static volatile boolean finalized = false;
    private final int index = FinalThreadStorage.newSlot(this);
    private final ThreadLocalInitialValue initial;
    private static final InheritableThreadLocal threadLocals = new InheritableThreadLocal(){

        protected Object initialValue() {
            return new FinalThreadStorage();
        }

        protected Object childValue(Object object) {
            try {
                return new FinalThreadStorage(((AuditableThread)Thread.currentThread()).finalThreadStorage);
            }
            catch (ClassCastException classCastException) {
                if (object != null) {
                    return new FinalThreadStorage((FinalThreadStorage)object);
                }
                return null;
            }
        }
    };
    static /* synthetic */ Class class$weblogic$kernel$FinalThreadLocal$FinalThreadStorage;

    FinalThreadLocal() {
        this.initial = new ThreadLocalInitialValue();
    }

    FinalThreadLocal(ThreadLocalInitialValue threadLocalInitialValue) {
        this.initial = threadLocalInitialValue;
    }

    public Object get() {
        try {
            return ((AuditableThread)Thread.currentThread()).finalThreadStorage.get(this.index);
        }
        catch (ClassCastException classCastException) {
            return this.get((ThreadStorage)threadLocals.get());
        }
    }

    public Object get(AuditableThread auditableThread) {
        if (auditableThread == null) {
            return null;
        }
        return auditableThread.finalThreadStorage.get(this.index);
    }

    private Object get(ThreadStorage threadStorage) {
        if (threadStorage == null) {
            return null;
        }
        return threadStorage.get(this.index);
    }

    public void set(Object object) {
        try {
            ((AuditableThread)Thread.currentThread()).finalThreadStorage.set(this.index, object);
        }
        catch (ClassCastException classCastException) {
            this.set((ThreadStorage)threadLocals.get(), object);
        }
    }

    private void set(ThreadStorage threadStorage, Object object) {
        if (threadStorage == null) {
            return;
        }
        threadStorage.set(this.index, object);
    }

    static boolean isFinalized() {
        return finalized;
    }

    static final void resetJavaThreadStorage() {
        threadLocals.set(null);
    }

    static final class FinalThreadStorage
    implements ThreadStorage {
        private static FinalThreadLocal[] varList = new FinalThreadLocal[0];
        private final Object[] storage;
        private final int NUM_SLOTS;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int newSlot(FinalThreadLocal finalThreadLocal) {
            if (finalized) {
                throw new AssertionError((Object)"A FinalThreadLocal was allocated after thread creation.");
            }
            Class clazz = class$weblogic$kernel$FinalThreadLocal$FinalThreadStorage == null ? (class$weblogic$kernel$FinalThreadLocal$FinalThreadStorage = FinalThreadLocal.class$("weblogic.kernel.FinalThreadLocal$FinalThreadStorage")) : class$weblogic$kernel$FinalThreadLocal$FinalThreadStorage;
            synchronized (clazz) {
                int n = varList.length;
                FinalThreadLocal[] finalThreadLocalArray = new FinalThreadLocal[n + 1];
                System.arraycopy(varList, 0, finalThreadLocalArray, 0, n);
                finalThreadLocalArray[n] = finalThreadLocal;
                varList = finalThreadLocalArray;
                return n;
            }
        }

        public FinalThreadStorage() {
            finalized = true;
            this.NUM_SLOTS = varList.length;
            this.storage = new Object[this.NUM_SLOTS];
            for (int i = 0; i < this.NUM_SLOTS; ++i) {
                this.storage[i] = varList[i].initial.initialValue();
            }
        }

        protected FinalThreadStorage(FinalThreadStorage finalThreadStorage) {
            this.NUM_SLOTS = varList.length;
            this.storage = new Object[this.NUM_SLOTS];
            for (int i = 0; i < this.NUM_SLOTS; ++i) {
                this.storage[i] = finalThreadStorage != null ? varList[i].initial.childValue(finalThreadStorage.storage[i]) : varList[i].initial.initialValue();
            }
        }

        public void set(int n, Object object) {
            this.storage[n] = object;
        }

        public Object get(int n) {
            return this.storage[n];
        }

        public final void reset() {
            Object[] objectArray = this.storage;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                objectArray[i] = varList[i].initial.resetValue(object);
            }
        }
    }
}

