/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.extensions;

import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitor;
import weblogic.rmi.extensions.DisconnectMonitorList;
import weblogic.rmi.extensions.DisconnectMonitorUnavailableException;
import weblogic.rmi.extensions.server.DisconnectMonitorProvider;

public class DisconnectMonitorListImpl
implements DisconnectMonitor,
DisconnectMonitorList {
    private static ArrayList disconnectMonitorList = new ArrayList();

    private DisconnectMonitorListImpl() {
    }

    private static DisconnectMonitorListImpl getInstance() {
        return DisconnectMonitorListImplSingleton.theDisconnectMonitorList;
    }

    public static DisconnectMonitorList getDisconnectMonitorList() {
        return DisconnectMonitorListImpl.getInstance();
    }

    public static DisconnectMonitor getDisconnectMonitor() {
        return DisconnectMonitorListImpl.getInstance();
    }

    public synchronized void addDisconnectMonitor(DisconnectMonitorProvider disconnectMonitorProvider) {
        disconnectMonitorList.add(disconnectMonitorProvider);
    }

    public synchronized void removeDisconnectMonitor(DisconnectMonitorProvider disconnectMonitorProvider) {
        disconnectMonitorList.remove(disconnectMonitorProvider);
    }

    public synchronized void addDisconnectListener(Remote remote, DisconnectListener disconnectListener) throws DisconnectMonitorUnavailableException {
        Iterator iterator = disconnectMonitorList.iterator();
        while (iterator.hasNext()) {
            DisconnectMonitorProvider disconnectMonitorProvider = (DisconnectMonitorProvider)iterator.next();
            if (!disconnectMonitorProvider.addDisconnectListener(remote, disconnectListener)) continue;
            return;
        }
        throw new DisconnectMonitorUnavailableException("Could not register a DisconnectListener for [" + remote + "]");
    }

    public synchronized void removeDisconnectListener(Remote remote, DisconnectListener disconnectListener) throws DisconnectMonitorUnavailableException {
        Iterator iterator = disconnectMonitorList.iterator();
        while (iterator.hasNext()) {
            DisconnectMonitorProvider disconnectMonitorProvider = (DisconnectMonitorProvider)iterator.next();
            if (!disconnectMonitorProvider.removeDisconnectListener(remote, disconnectListener)) continue;
            return;
        }
        throw new DisconnectMonitorUnavailableException("No registration found for [" + remote + "]");
    }

    public static void bindToJNDI(Context context) throws NamingException {
        context.bind("weblogic.DisconnectMonitor", (Object)DisconnectMonitorListImpl.getDisconnectMonitor());
    }

    public static void unbindFromJNDI(Context context) throws NamingException {
        context.unbind("weblogic.DisconnectMonitor");
    }

    private static final class DisconnectMonitorListImplSingleton {
        private static final DisconnectMonitorListImpl theDisconnectMonitorList = new DisconnectMonitorListImpl();

        private DisconnectMonitorListImplSingleton() {
        }
    }
}

