/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public final class Security {
    private static final AbstractSubject kernelID = Security.getKernelIdentity();

    private static final AbstractSubject getKernelIdentity() {
        try {
            return (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    public static Object runAs(Subject subject, PrivilegedAction privilegedAction) throws IllegalArgumentException {
        return SubjectManager.getSubjectManager().runAs(subject, privilegedAction);
    }

    public static Object runAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException, IllegalArgumentException {
        return SubjectManager.getSubjectManager().runAs(subject, privilegedExceptionAction);
    }

    public static Subject getCurrentSubject() {
        return SubjectManager.getSubjectManager().getCurrentSubject(kernelID).getSubject();
    }
}

