/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.auth.login;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import weblogic.corba.client.ClientORBInitializer;
import weblogic.corba.client.spi.ServiceManager;
import weblogic.security.auth.callback.URLCallback;
import weblogic.security.auth.login.PasswordCredential;
import weblogic.security.subject.SubjectProxy;

public class UsernamePasswordLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler = null;
    private Map sharedState = null;
    private Map options = null;
    private boolean debug = false;
    private boolean authOnLogin = false;
    private String url = null;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username = null;
    private String password = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.subject = subject;
        if (map2 != null) {
            Object v = map2.get("debug");
            if (v != null && ((String)v).equalsIgnoreCase("true")) {
                this.debug = true;
                this.log("UsernamePasswordLoginModule.initialize(), debug enabled");
            }
            if ((v = map2.get("URL")) != null) {
                this.url = (String)v;
                if (this.debug) {
                    this.log("UsernamePasswordLoginModule.initialize(), URL " + this.url);
                }
            }
            if ((v = map2.get("authOnLogin")) != null && ((String)v).equalsIgnoreCase("true")) {
                this.authOnLogin = true;
                if (this.debug) {
                    this.log("UsernamePasswordLoginModule.initialize(), authOnLogin enabled");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        block31: {
            Object object;
            if (this.callbackHandler == null) {
                if (this.debug) {
                    this.log("UsernamePasswordLoginModule.login(), no callback handler specifed");
                }
                throw new LoginException("No callback handler specified");
            }
            Callback[] callbackArray = new Callback[]{new NameCallback("username: "), new PasswordCallback("password: ", false), new URLCallback("URL: ")};
            try {
                this.callbackHandler.handle(callbackArray);
                this.username = ((NameCallback)callbackArray[0]).getName();
                if (this.debug) {
                    if (this.username == null) {
                        this.log("UsernamePasswordLoginModule.login(), No username");
                    } else {
                        this.log("UsernamePasswordLoginModule.login(), username " + this.username);
                    }
                }
                if (this.username == null) {
                    throw new LoginException("No username specified");
                }
                object = ((PasswordCallback)callbackArray[1]).getPassword();
                if (object == null) {
                    object = new char[]{};
                }
                this.password = new String((char[])object);
                String string = ((URLCallback)callbackArray[2]).getURL();
                if (string != null) {
                    this.url = string;
                }
                if (this.debug) {
                    if (this.url == null) {
                        this.log("UsernamePasswordLoginModule.login(), No URL");
                    } else {
                        this.log("UsernamePasswordLoginModule.login(), URL " + this.url);
                    }
                }
                if (this.url == null) {
                    this.url = "";
                }
            }
            catch (IOException iOException) {
                if (this.debug) {
                    this.log("UsernamePasswordLoginModule CallbackHandler Error: " + iOException.getMessage());
                }
                throw new LoginException(iOException.toString());
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                if (this.debug) {
                    this.log("UsernamePasswordLoginModule CallbackHandler Error: " + unsupportedCallbackException.getMessage());
                }
                throw new LoginException("Callback not available: " + unsupportedCallbackException.getCallback().toString());
            }
            if (this.url != null) {
                try {
                    if (this.authOnLogin) {
                        try {
                            object = new Hashtable();
                            object.put("java.naming.provider.url", this.url);
                            object.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                            object.put("java.naming.security.principal", this.username);
                            object.put("java.naming.security.credentials", this.password);
                            new InitialContext((Hashtable<?, ?>)object).lookup("weblogic/security/SecurityManager");
                            break block31;
                        }
                        finally {
                            try {
                                ServiceManager.getSecurityManager().popSubject();
                            }
                            catch (EmptyStackException emptyStackException) {}
                        }
                    }
                    ClientORBInitializer.initialize();
                }
                catch (SecurityException securityException) {
                    if (this.debug) {
                        this.log("UsernamePasswordLoginModule Error: SecurityException on authenticate, " + securityException.getMessage());
                    }
                    throw new LoginException(securityException.toString());
                }
                catch (NamingException namingException) {
                    if (this.debug) {
                        this.log("UsernamePasswordLoginModule Error: NamingException on authenticate, " + namingException.getMessage());
                    }
                    throw new LoginException(namingException.toString());
                }
            }
        }
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.succeeded) {
            final PasswordCredential passwordCredential = new PasswordCredential(this.username, this.password);
            final SubjectProxy subjectProxy = new SubjectProxy(this.subject);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    UsernamePasswordLoginModule.this.subject.getPrivateCredentials().add(passwordCredential);
                    UsernamePasswordLoginModule.this.subject.getPrivateCredentials().add(subjectProxy);
                    return null;
                }
            });
            this.url = null;
            this.commitSucceeded = true;
            return true;
        }
        this.username = null;
        this.password = null;
        this.url = null;
        return false;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            this.password = null;
            this.url = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        block2: {
            this.succeeded = false;
            this.commitSucceeded = false;
            this.username = null;
            this.password = null;
            this.url = null;
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        UsernamePasswordLoginModule.this.subject.getPrincipals().clear();
                        UsernamePasswordLoginModule.this.subject.getPrivateCredentials().clear();
                        UsernamePasswordLoginModule.this.subject.getPublicCredentials().clear();
                        return null;
                    }
                });
            }
            catch (SecurityException securityException) {
                if (!this.debug) break block2;
                securityException.printStackTrace();
            }
        }
        return true;
    }

    private void log(String string) {
        System.out.println(string);
    }
}

