/*
 * Decompiled with CFR 0.152.
 */
package weblogic.workarea;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import weblogic.workarea.PrimitiveWorkContext;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextOutput;

public class SerializableWorkContext
implements PrimitiveWorkContext,
Serializable {
    private byte[] data;
    private transient Serializable object;

    public SerializableWorkContext() {
    }

    SerializableWorkContext(Serializable serializable) throws IOException {
        this.object = serializable;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        objectOutputStream.close();
        this.data = byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        return "Serializable";
    }

    public Object get() {
        try {
            return this.getSerializable();
        }
        catch (IOException iOException) {
            return this.data;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.data;
        }
    }

    public Serializable getSerializable() throws IOException, ClassNotFoundException {
        if (this.object != null) {
            return this.object;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        this.object = (Serializable)objectInputStream.readObject();
        objectInputStream.close();
        return this.object;
    }

    public boolean equals(Object object) {
        if (object instanceof SerializableWorkContext) {
            return Arrays.equals(((SerializableWorkContext)object).data, this.data);
        }
        return false;
    }

    public void writeContext(WorkContextOutput workContextOutput) throws IOException {
        workContextOutput.writeInt(this.data.length);
        workContextOutput.write(this.data);
    }

    public void readContext(WorkContextInput workContextInput) throws IOException {
        this.data = new byte[workContextInput.readInt()];
        workContextInput.readFully(this.data);
    }
}

