/*
 * Decompiled with CFR 0.152.
 */
package weblogic.workarea;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.workarea.NoWorkContextException;
import weblogic.workarea.PropertyReadOnlyException;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextMap;
import weblogic.workarea.WorkContextOutput;
import weblogic.workarea.spi.WorkContextAccessController;
import weblogic.workarea.spi.WorkContextEntry;
import weblogic.workarea.spi.WorkContextEntryImpl;
import weblogic.workarea.spi.WorkContextMapInterceptor;

final class WorkContextLocalMap
implements WorkContextMap,
WorkContextMapInterceptor {
    private final HashMap map = new HashMap();
    private int version = this.hashCode();
    private static final boolean DEBUG = false;

    WorkContextLocalMap() {
    }

    public WorkContext put(String string, WorkContext workContext, int n) throws PropertyReadOnlyException {
        if (string == null || string.equals("")) {
            throw new NullPointerException("Cannot use null key");
        }
        if (workContext == null) {
            throw new NullPointerException("Cannot use null WorkContext");
        }
        WorkContextEntry workContextEntry = (WorkContextEntry)this.map.get(string);
        if (workContextEntry != null) {
            if (!WorkContextAccessController.isAccessAllowed(string, 2)) {
                throw new PropertyReadOnlyException(string);
            }
        } else if (!WorkContextAccessController.isAccessAllowed(string, 0)) {
            throw new AccessControlException("No CREATE permission for key: \"" + string + "\"");
        }
        this.map.put(string, new WorkContextEntryImpl(string, workContext, n));
        ++this.version;
        return workContextEntry == null ? null : workContextEntry.getWorkContext();
    }

    public WorkContext put(String string, WorkContext workContext) throws PropertyReadOnlyException {
        return this.put(string, workContext, 212);
    }

    public WorkContext get(String string) {
        if (!WorkContextAccessController.isAccessAllowed(string, 1)) {
            throw new AccessControlException("No READ permission for key: \"" + string + "\"");
        }
        WorkContextEntry workContextEntry = this.getEntry(string);
        if (workContextEntry == WorkContextEntry.NULL_CONTEXT) {
            return null;
        }
        return workContextEntry.getWorkContext();
    }

    public WorkContext remove(String string) throws NoWorkContextException, PropertyReadOnlyException {
        WorkContextEntry workContextEntry = this.getEntry(string);
        if (workContextEntry == WorkContextEntry.NULL_CONTEXT) {
            throw new NoWorkContextException(string);
        }
        if (!workContextEntry.isOriginator() && !WorkContextAccessController.isAccessAllowed(string, 3)) {
            throw new PropertyReadOnlyException("No DELETE permission for key: \"" + string + "\"");
        }
        this.map.remove(string);
        ++this.version;
        return workContextEntry.getWorkContext();
    }

    public int getPropagationMode(String string) {
        if (!WorkContextAccessController.isAccessAllowed(string, 1)) {
            throw new AccessControlException("No READ permission for key: \"" + string + "\"");
        }
        return this.getEntry(string).getPropagationMode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Iterator iterator() {
        return new WorkContextIterator(this);
    }

    public Iterator keys() {
        return new WorkContextKeys(this);
    }

    private final WorkContextEntry getEntry(String string) {
        WorkContextEntry workContextEntry;
        if (this.map.isEmpty() || (workContextEntry = (WorkContextEntry)this.map.get(string)) == null) {
            return WorkContextEntry.NULL_CONTEXT;
        }
        return workContextEntry;
    }

    public void sendRequest(WorkContextOutput workContextOutput, int n) throws IOException {
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            WorkContextEntry workContextEntry = (WorkContextEntry)iterator.next();
            if ((workContextEntry.getPropagationMode() & n) == 0) continue;
            workContextEntry.write(workContextOutput);
        }
        WorkContextEntry.NULL_CONTEXT.write(workContextOutput);
    }

    public void sendResponse(WorkContextOutput workContextOutput, int n) throws IOException {
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            WorkContextEntry workContextEntry = (WorkContextEntry)iterator.next();
            if ((workContextEntry.getPropagationMode() & 0x100) != 0 || (workContextEntry.getPropagationMode() & n) == 0) continue;
            workContextEntry.write(workContextOutput);
        }
        WorkContextEntry.NULL_CONTEXT.write(workContextOutput);
    }

    public void receiveRequest(WorkContextInput workContextInput) throws IOException {
        while (true) {
            try {
                WorkContextEntry workContextEntry;
                while ((workContextEntry = WorkContextEntryImpl.readEntry(workContextInput)) != WorkContextEntry.NULL_CONTEXT) {
                    String string = workContextEntry.getName();
                    this.map.put(string, workContextEntry);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            break;
        }
    }

    public void receiveResponse(WorkContextInput workContextInput) throws IOException {
        Object object = this.map.values().iterator();
        while (object.hasNext()) {
            WorkContextEntry workContextEntry = (WorkContextEntry)object.next();
            if ((workContextEntry.getPropagationMode() & 0x100) != 0) continue;
            object.remove();
            ++this.version;
        }
        if (workContextInput == null) {
            return;
        }
        block3: while (true) {
            try {
                while (true) {
                    object = WorkContextEntryImpl.readEntry(workContextInput);
                    ++this.version;
                    if (object == WorkContextEntry.NULL_CONTEXT) break block3;
                    this.map.put(object.getName(), object);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            break;
        }
    }

    public WorkContextMapInterceptor copyThreadContexts(int n) {
        if (this.map.isEmpty()) {
            return null;
        }
        WorkContextLocalMap workContextLocalMap = new WorkContextLocalMap();
        workContextLocalMap.map.putAll(this.map);
        workContextLocalMap.version = this.version;
        Iterator iterator = workContextLocalMap.map.values().iterator();
        while (iterator.hasNext()) {
            WorkContextEntry workContextEntry = (WorkContextEntry)iterator.next();
            if ((workContextEntry.getPropagationMode() & n) != 0) continue;
            iterator.remove();
        }
        if (workContextLocalMap.map.isEmpty()) {
            return null;
        }
        return workContextLocalMap;
    }

    public void restoreThreadContexts(WorkContextMapInterceptor workContextMapInterceptor) {
        if (workContextMapInterceptor == this) {
            throw new AssertionError((Object)"Cyclic attempt to restore thread contexts");
        }
        if (workContextMapInterceptor == null) {
            return;
        }
        this.map.clear();
        this.map.putAll(((WorkContextLocalMap)workContextMapInterceptor).map);
        ++this.version;
    }

    public WorkContextMapInterceptor suspendThreadContexts() {
        throw new UnsupportedOperationException("suspendThreadContexts()");
    }

    public void resumeThreadContexts(WorkContextMapInterceptor workContextMapInterceptor) {
        throw new UnsupportedOperationException("resumeThreadContexts()");
    }

    public int version() {
        return this.version;
    }

    private static void p(String string) {
        System.out.println("<WorkContextLocalMap>: " + string);
    }

    private final class WorkContextKeys
    implements Iterator {
        final Iterator iter;

        private WorkContextKeys(WorkContextLocalMap workContextLocalMap2) {
            this.iter = workContextLocalMap2.map.values().iterator();
        }

        public void remove() {
            WorkContextLocalMap.this.version++;
            this.iter.remove();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            WorkContextEntry workContextEntry = (WorkContextEntry)this.iter.next();
            while (workContextEntry != null && !WorkContextAccessController.isAccessAllowed(workContextEntry.getName(), 1)) {
                workContextEntry = (WorkContextEntry)this.iter.next();
            }
            return workContextEntry == null ? null : workContextEntry.getName();
        }
    }

    private final class WorkContextIterator
    implements Iterator {
        final Iterator iter;

        private WorkContextIterator(WorkContextLocalMap workContextLocalMap2) {
            this.iter = workContextLocalMap2.map.values().iterator();
        }

        public void remove() {
            WorkContextLocalMap.this.version++;
            this.iter.remove();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            WorkContextEntry workContextEntry = (WorkContextEntry)this.iter.next();
            while (workContextEntry != null && !WorkContextAccessController.isAccessAllowed(workContextEntry.getName(), 1)) {
                workContextEntry = (WorkContextEntry)this.iter.next();
            }
            return workContextEntry == null ? null : workContextEntry.getWorkContext();
        }
    }
}

