/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAP11Constants;
import org.apache.ws.security.SOAP12Constants;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.StringUtil;
import org.apache.xml.security.algorithms.JCEMapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSSecurityUtil {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$ws$security$util$WSSecurityUtil == null ? (class$org$apache$ws$security$util$WSSecurityUtil = WSSecurityUtil.class$("org.apache.ws.security.util.WSSecurityUtil")) : class$org$apache$ws$security$util$WSSecurityUtil));
    private static boolean doDebug = false;
    static /* synthetic */ Class class$org$apache$ws$security$util$WSSecurityUtil;

    public static Element getSecurityHeader(Document doc, String actor, SOAPConstants sc) {
        Element soapHeaderElement = (Element)WSSecurityUtil.getDirectChild(doc.getFirstChild(), sc.getHeaderQName().getLocalPart(), sc.getEnvelopeURI());
        if (soapHeaderElement == null) {
            return null;
        }
        NodeList list = null;
        int len = 0;
        list = soapHeaderElement.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        if (list == null) {
            return null;
        }
        len = list.getLength();
        for (int i = 0; i < len; ++i) {
            String hActor;
            Element elem = (Element)list.item(i);
            Attr attr = elem.getAttributeNodeNS(sc.getEnvelopeURI(), sc.getRoleAttributeQName().getLocalPart());
            String string = hActor = attr != null ? attr.getValue() : null;
            if (!WSSecurityUtil.isActorEqual(actor, hActor)) continue;
            return elem;
        }
        return null;
    }

    public static boolean isActorEqual(String actor, String hActor) {
        return (hActor == null || hActor.length() == 0) && (actor == null || actor.length() == 0) || hActor != null && actor != null && hActor.equalsIgnoreCase(actor);
    }

    public static Node getDirectChild(Node fNode, String localName, String namespace) {
        for (Node currentChild = fNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!localName.equals(currentChild.getLocalName()) || !namespace.equals(currentChild.getNamespaceURI())) continue;
            return currentChild;
        }
        return null;
    }

    public static Element findBodyElement(Document doc, SOAPConstants sc) {
        Element soapBodyElement = (Element)WSSecurityUtil.getDirectChild(doc.getFirstChild(), sc.getBodyQName().getLocalPart(), sc.getEnvelopeURI());
        return soapBodyElement;
    }

    public static Node findElement(Node startNode, String name, String namespace) {
        if (startNode == null) {
            return null;
        }
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        while (startNode != null) {
            if (startNode.getNodeType() == 1 && startNode.getLocalName().equals(name)) {
                String ns = startNode.getNamespaceURI();
                if (ns != null && ns.equals(namespace)) {
                    return startNode;
                }
                if (!(namespace != null && namespace.length() != 0 || ns != null && ns.length() != 0)) {
                    return startNode;
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return null;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return null;
    }

    public static Element findElementById(Node startNode, String value, String namespace) {
        Element foundElement = null;
        if (startNode == null) {
            return null;
        }
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        while (startNode != null) {
            Element se;
            if (startNode.getNodeType() == 1 && (se = (Element)startNode).hasAttributeNS(namespace, "Id") && value.equals(se.getAttributeNS(namespace, "Id"))) {
                if (foundElement == null) {
                    foundElement = se;
                } else {
                    log.warn((Object)"Multiple elements with the same 'Id' attribute value!");
                    return null;
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return foundElement;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return foundElement;
    }

    public static String setNamespace(Element element, String namespace, String prefix) {
        String pre = WSSecurityUtil.getPrefixNS(namespace, element);
        if (pre != null) {
            return pre;
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
        return prefix;
    }

    public static String getPrefixNS(String uri, Node e) {
        while (e != null && e.getNodeType() == 1) {
            NamedNodeMap attrs = e.getAttributes();
            for (int n = 0; n < attrs.getLength(); ++n) {
                Attr a = (Attr)attrs.item(n);
                String name = a.getName();
                if (!name.startsWith("xmlns:") || !a.getNodeValue().equals(uri)) continue;
                return name.substring(6);
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static String getNamespace(String prefix, Node e) {
        while (e != null && e.getNodeType() == 1) {
            Attr attr = null;
            attr = prefix == null ? ((Element)e).getAttributeNode("xmlns") : ((Element)e).getAttributeNodeNS("http://www.w3.org/2000/xmlns/", prefix);
            if (attr != null) {
                return attr.getValue();
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static QName getQNameFromString(String str, Node e) {
        return WSSecurityUtil.getQNameFromString(str, e, false);
    }

    public static QName getFullQNameFromString(String str, Node e) {
        return WSSecurityUtil.getQNameFromString(str, e, true);
    }

    private static QName getQNameFromString(String str, Node e, boolean defaultNS) {
        String ns;
        if (str == null || e == null) {
            return null;
        }
        int idx = str.indexOf(58);
        if (idx > -1) {
            String prefix = str.substring(0, idx);
            String ns2 = WSSecurityUtil.getNamespace(prefix, e);
            if (ns2 == null) {
                return null;
            }
            return new QName(ns2, str.substring(idx + 1));
        }
        if (defaultNS && (ns = WSSecurityUtil.getNamespace(null, e)) != null) {
            return new QName(ns, str);
        }
        return new QName("", str);
    }

    public static String getStringForQName(QName qname, Element e) {
        String uri = qname.getNamespaceURI();
        String prefix = WSSecurityUtil.getPrefixNS(uri, e);
        if (prefix == null) {
            int i = 1;
            prefix = "ns" + i;
            while (WSSecurityUtil.getNamespace(prefix, e) != null) {
                prefix = "ns" + ++i;
            }
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
        }
        return prefix + ":" + qname.getLocalPart();
    }

    public static Element getElementByWsuId(Document doc, String id) {
        if (id == null) {
            return null;
        }
        id = WSSecurityUtil.getIDfromReference(id);
        return WSSecurityUtil.findElementById(doc.getDocumentElement(), id, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
    }

    public static String getIDfromReference(String ref) {
        String id = ref.trim();
        if (id.length() == 0 || id.charAt(0) != '#') {
            return null;
        }
        return id.substring(1);
    }

    public static Element getElementByGenId(Document doc, String id) {
        if (id == null) {
            return null;
        }
        if ((id = id.trim()).length() == 0 || id.charAt(0) != '#') {
            return null;
        }
        id = id.substring(1);
        return WSSecurityUtil.findElementById(doc.getDocumentElement(), id, null);
    }

    public static Element createBinarySecurityToken(Document doc, String wsuIdVal) {
        Element retVal = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken");
        retVal.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        retVal.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", wsuIdVal);
        retVal.setAttributeNS(null, "ValueType", X509Security.getType());
        retVal.setAttributeNS(null, "EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        return retVal;
    }

    private static Element createElementInSameNamespace(Element parent, String localName) {
        String prefix = parent.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        String qName = prefix + ":" + localName;
        String nsUri = parent.getNamespaceURI();
        return parent.getOwnerDocument().createElementNS(nsUri, qName);
    }

    private static Element findChildElement(Element parent, String namespaceUri, String localName) {
        NodeList children = parent.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Element elementChild;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !namespaceUri.equals((elementChild = (Element)child).getNamespaceURI()) || !localName.equals(elementChild.getLocalName())) continue;
            return elementChild;
        }
        return null;
    }

    public static Element appendChildElement(Document doc, Element parent, Element child) {
        Text whitespaceText = doc.createTextNode("\n");
        parent.appendChild(whitespaceText);
        parent.appendChild(child);
        return child;
    }

    public static Element prependChildElement(Document doc, Element parent, Element child, boolean addWhitespace) {
        Node firstChild = parent.getFirstChild();
        if (firstChild == null) {
            parent.appendChild(child);
        } else {
            parent.insertBefore(child, firstChild);
        }
        if (addWhitespace) {
            Text whitespaceText = doc.createTextNode("\n");
            parent.insertBefore(whitespaceText, child);
        }
        return child;
    }

    public static Element findWsseSecurityHeaderBlock(Document doc, Element envelope, boolean doCreate) {
        return WSSecurityUtil.findWsseSecurityHeaderBlock(doc, envelope, null, doCreate);
    }

    public static Element findWsseSecurityHeaderBlock(Document doc, Element envelope, String actor, boolean doCreate) {
        SOAPConstants sc = WSSecurityUtil.getSOAPConstants(envelope);
        Element wsseSecurity = WSSecurityUtil.getSecurityHeader(doc, actor, sc);
        if (wsseSecurity != null) {
            return wsseSecurity;
        }
        Element header = WSSecurityUtil.findChildElement(envelope, sc.getEnvelopeURI(), sc.getHeaderQName().getLocalPart());
        if (header == null && doCreate) {
            header = WSSecurityUtil.createElementInSameNamespace(envelope, sc.getHeaderQName().getLocalPart());
            header = WSSecurityUtil.prependChildElement(doc, envelope, header, true);
        }
        if (doCreate) {
            wsseSecurity = header.getOwnerDocument().createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
            wsseSecurity.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            return WSSecurityUtil.prependChildElement(doc, header, wsseSecurity, true);
        }
        return null;
    }

    public static Text createBase64EncodedTextNode(Document doc, byte[] data) {
        return doc.createTextNode(Base64.encode(data));
    }

    public static SecretKey prepareSecretKey(String symEncAlgo, byte[] rawKey) {
        SecretKeySpec keySpec = new SecretKeySpec(rawKey, JCEMapper.getJCEKeyAlgorithmFromURI((String)symEncAlgo));
        return keySpec;
    }

    public static SOAPConstants getSOAPConstants(Element startElement) {
        Document doc = startElement.getOwnerDocument();
        String ns = doc.getDocumentElement().getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(ns)) {
            return new SOAP12Constants();
        }
        return new SOAP11Constants();
    }

    public static Cipher getCipherInstance(String cipherAlgo) throws WSSecurityException {
        Cipher cipher;
        block5: {
            cipher = null;
            try {
                if (cipherAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
                    cipher = Cipher.getInstance("RSA/NONE/PKCS1PADDING");
                    break block5;
                }
                if (cipherAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
                    cipher = Cipher.getInstance("RSA/NONE/OAEPPADDING");
                    break block5;
                }
                throw new WSSecurityException(2, "unsupportedKeyTransp", new Object[]{cipherAlgo});
            }
            catch (NoSuchPaddingException ex) {
                throw new WSSecurityException(2, "unsupportedKeyTransp", new Object[]{"No such padding: " + cipherAlgo});
            }
            catch (NoSuchAlgorithmException ex) {
                throw new WSSecurityException(2, "unsupportedKeyTransp", new Object[]{"No such algorithm: " + cipherAlgo});
            }
        }
        return cipher;
    }

    public static WSSecurityEngineResult fetchActionResult(Vector wsResultVector, int action) {
        WSSecurityEngineResult wsResult = null;
        for (int i = 0; i < wsResultVector.size(); ++i) {
            if (((WSSecurityEngineResult)wsResultVector.get(i)).getAction() != action) continue;
            wsResult = (WSSecurityEngineResult)wsResultVector.get(i);
        }
        return wsResult;
    }

    public static Vector fetchAllActionResults(Vector wsResultVector, int action, Vector results) {
        for (int i = 0; i < wsResultVector.size(); ++i) {
            if (((WSSecurityEngineResult)wsResultVector.get(i)).getAction() != action) continue;
            results.add(wsResultVector.get(i));
        }
        return results;
    }

    public static int decodeAction(String action, Vector actions) throws WSSecurityException {
        int doAction = 0;
        if (action == null) {
            return doAction;
        }
        String[] single = StringUtil.split(action, ' ');
        for (int i = 0; i < single.length; ++i) {
            if (single[i].equals("NoSecurity")) {
                doAction = 0;
                return doAction;
            }
            if (single[i].equals("UsernameToken")) {
                doAction |= 1;
                actions.add(new Integer(1));
                continue;
            }
            if (single[i].equals("Signature")) {
                doAction |= 2;
                actions.add(new Integer(2));
                continue;
            }
            if (single[i].equals("Encrypt")) {
                doAction |= 4;
                actions.add(new Integer(4));
                continue;
            }
            if (single[i].equals("SAMLTokenUnsigned")) {
                doAction |= 8;
                actions.add(new Integer(8));
                continue;
            }
            if (single[i].equals("SAMLTokenSigned")) {
                doAction |= 0x10;
                actions.add(new Integer(16));
                continue;
            }
            if (single[i].equals("Timestamp")) {
                doAction |= 0x20;
                actions.add(new Integer(32));
                continue;
            }
            if (single[i].equals("NoSerialization")) {
                doAction |= 0x100;
                actions.add(new Integer(256));
                continue;
            }
            if (single[i].equals("UsernameTokenSignature")) {
                doAction |= 0x40;
                actions.add(new Integer(64));
                continue;
            }
            throw new WSSecurityException("WSDoAllSender: Unknown action defined" + single[i]);
        }
        return doAction;
    }

    public static int getKeyLength(String algorithm) throws WSSecurityException {
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            return 24;
        }
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
            return 16;
        }
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
            return 24;
        }
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            return 32;
        }
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(algorithm)) {
            return 20;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256".equals(algorithm)) {
            return 32;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384".equals(algorithm)) {
            return 48;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512".equals(algorithm)) {
            return 64;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-md5".equals(algorithm)) {
            return 16;
        }
        throw new WSSecurityException(2, null, null, null);
    }

    public static byte[] generateNonce(int length) throws WSSecurityException {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] temp = new byte[length];
            random.nextBytes(temp);
            return temp;
        }
        catch (Exception e) {
            throw new WSSecurityException("Error in generating nonce of length " + length, e);
        }
    }

    public static X509Certificate ensureSignedTogether(Iterator results, Element[] elements) throws WSSecurityException {
        log.debug((Object)"ensureSignedTogether()");
        if (results == null) {
            throw new IllegalArgumentException("No results vector");
        }
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("No elements to check!");
        }
        String[] requiredIDs = new String[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            Element e = elements[i];
            if (e == null) {
                throw new IllegalArgumentException("elements[" + i + "] is null!");
            }
            requiredIDs[i] = e.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
            if (requiredIDs[i] == null) {
                throw new WSSecurityException(6, "requiredElementNoID", new Object[]{e.getNodeName()});
            }
            log.debug((Object)("Required element " + e.getNodeName() + " has wsu:Id " + requiredIDs[i]));
        }
        WSSecurityException fault = null;
        while (results.hasNext()) {
            WSHandlerResult result = (WSHandlerResult)results.next();
            Iterator actions = result.getResults().iterator();
            while (actions.hasNext()) {
                WSSecurityEngineResult resultItem = (WSSecurityEngineResult)actions.next();
                if (resultItem.getAction() != 2) continue;
                try {
                    WSSecurityUtil.checkSignsAllElements(resultItem, requiredIDs);
                    return resultItem.getCertificate();
                }
                catch (WSSecurityException ex) {
                    log.debug((Object)"SIGN result does not sign all required elements", (Throwable)ex);
                    fault = ex;
                }
            }
        }
        if (fault != null) {
            throw fault;
        }
        throw new WSSecurityException(6, "noSignResult");
    }

    private static void checkSignsAllElements(WSSecurityEngineResult resultItem, String[] requiredIDs) throws WSSecurityException {
        if (resultItem.getAction() != 2) {
            throw new IllegalArgumentException("Not a SIGN result");
        }
        Set signedIDs = resultItem.getSignedElements();
        if (signedIDs == null) {
            throw new RuntimeException("Missing signedElements set in WSSecurityEngineResult!");
        }
        log.debug((Object)"Found SIGN result...");
        Iterator i = signedIDs.iterator();
        while (i.hasNext()) {
            String e = (String)i.next();
            log.debug((Object)("Signature includes element with ID " + e));
        }
        log.debug((Object)"Checking required elements are in the signature...");
        for (int i2 = 0; i2 < requiredIDs.length; ++i2) {
            if (!signedIDs.contains(requiredIDs[i2])) {
                throw new WSSecurityException(6, "requiredElementNotSigned", new Object[]{requiredIDs[i2]});
            }
            log.debug((Object)("Element with ID " + requiredIDs[i2] + " was correctly signed"));
        }
        log.debug((Object)"All required elements are signed");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        doDebug = log.isDebugEnabled();
    }
}

