/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PdmGenerator {
    private String fromPdmFile = "";
    private String toPdmFile = "";
    private String wordFile = "";
    private String logFile = "ConvertPdm.log";
    private Object[] arrWord;

    public PdmGenerator(String string, String string2, String string3) throws Exception {
        this.fromPdmFile = string;
        this.wordFile = string3;
        this.toPdmFile = string2;
        System.out.println("\u5f00\u59cb\u89e3\u6790" + string3 + "\u6587\u4ef6...");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(string3));
        document.normalize();
        NodeList nodeList = document.getFirstChild().getChildNodes();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            treeSet.add(nodeList.item(i).getNodeName());
        }
        this.arrWord = treeSet.toArray();
    }

    public void convert() throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        System.out.println("\u5f00\u59cb\u89e3\u6790" + this.fromPdmFile + "\u6587\u4ef6...");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(this.fromPdmFile));
        document.normalize();
        NodeList nodeList = document.getElementsByTagName("o:Table");
        NodeList nodeList2 = null;
        Node node = null;
        NodeList nodeList3 = null;
        Node node2 = null;
        String string = "";
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.logFile, true));
        printWriter.println("=== Convert " + this.fromPdmFile + " to " + this.toPdmFile + " ===");
        System.out.println("\u5f00\u59cb\u8f6c\u6362...");
        for (n = 0; n < nodeList.getLength(); ++n) {
            nodeList2 = nodeList.item(n).getChildNodes();
            for (n2 = 0; n2 < nodeList2.getLength(); ++n2) {
                node = nodeList2.item(n2);
                if (node.getNodeName().equals("a:Code")) {
                    if (!this.updateValue(node)) {
                        printWriter.println(node.getFirstChild().getNodeValue());
                    }
                    string = node.getFirstChild().getNodeValue();
                    continue;
                }
                if (!node.getNodeName().equals("c:Columns")) continue;
                nodeList3 = ((Element)node).getElementsByTagName("o:Column");
                for (n3 = 0; n3 < nodeList3.getLength(); ++n3) {
                    node2 = ((Element)nodeList3.item(n3)).getElementsByTagName("a:Code").item(0);
                    if (node2 == null) {
                        printWriter.println("Ref col: tablecode=" + string + "\t column ID=" + ((Element)nodeList3.item(n3)).getAttributes().getNamedItem("Ref").getNodeValue().trim());
                        continue;
                    }
                    if (this.updateValue(node2)) continue;
                    printWriter.println(node2.getFirstChild().getNodeValue());
                }
            }
        }
        System.out.println("\u5f00\u59cb\u5199\u5165" + this.toPdmFile + "\u6587\u4ef6...");
        this.outputDocument(document, this.toPdmFile);
        printWriter.flush();
        printWriter.close();
    }

    private boolean updateValue(Node node) {
        int n = 0;
        String string = "";
        for (n = 0; n < this.arrWord.length; ++n) {
            string = (String)this.arrWord[n];
            if (!node.getFirstChild().getNodeValue().equalsIgnoreCase(string)) continue;
            node.getFirstChild().setNodeValue(string);
            return true;
        }
        return false;
    }

    public void outputDocument(Document document, String string) throws Exception {
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(new File(string));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(dOMSource, streamResult);
    }

    private static void printUsage() {
        System.out.println("Usage: java com.sinosoft.tools.PdmGenerator fromPdmFile toPdmFile wordrootFile");
        System.out.println("    fromPdmFile   \u9700\u8981\u8f6c\u6362\u7684pdm\u6587\u4ef6");
        System.out.println("    toPdmFile     \u751f\u6210\u7684pdm\u6587\u4ef6");
        System.out.println("    wordrootFile  \u5b9a\u4e49\u8bcd\u6839\u7684xml\u6587\u4ef6");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 3) {
            PdmGenerator.printUsage();
            return;
        }
        long l = new Date().getTime();
        PdmGenerator pdmGenerator = new PdmGenerator(stringArray[0], stringArray[1], stringArray[2]);
        pdmGenerator.convert();
        long l2 = new Date().getTime();
        System.out.print("\u603b\u5171\u65f6\u95f4\uff1a" + l2 + " - " + l + " = ");
        System.out.println(l2 - l + " ms");
    }
}

