/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.utility.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class DbPool {
    private Connection con = null;
    private Statement stmt = null;

    public Statement open(String string) throws SQLException, ClassNotFoundException, Exception {
        this.close();
        InitialContext initialContext = new InitialContext();
        DataSource dataSource = (DataSource)initialContext.lookup(string);
        this.con = dataSource.getConnection();
        try {
            this.stmt = this.con.createStatement(1004, 1007);
        }
        catch (SQLException sQLException) {
            this.con.close();
            throw sQLException;
        }
        return this.stmt;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = this.con.prepareStatement(string, 1004, 1007);
        return preparedStatement;
    }

    public void close() throws SQLException {
        SQLException sQLException = null;
        if (this.stmt != null) {
            try {
                this.stmt.close();
                this.stmt = null;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
        }
        if (this.con != null) {
            this.con.close();
            this.con = null;
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public void beginTransaction() throws SQLException {
        this.con.setAutoCommit(false);
    }

    public void commitTransaction() throws SQLException {
        this.con.commit();
        this.con.setAutoCommit(true);
    }

    public void rollbackTransaction() throws SQLException {
        this.con.rollback();
        this.con.setAutoCommit(true);
    }

    public ResultSet query(String string) throws SQLException {
        ResultSet resultSet = this.stmt.executeQuery(string);
        return resultSet;
    }

    public int getCount(String string) throws SQLException {
        ResultSet resultSet = this.stmt.executeQuery(string);
        return resultSet.getFetchSize();
    }

    public void insert(String string) throws SQLException, Exception {
        int n = this.stmt.executeUpdate(string);
        if (n == 0) {
            throw new Exception();
        }
    }

    public void update(String string) throws SQLException, Exception {
        int n = this.stmt.executeUpdate(string);
        if (n == 0) {
            throw new Exception();
        }
    }

    public void delete(String string) throws SQLException, Exception {
        int n = this.stmt.executeUpdate(string);
        if (n == 0) {
            throw new Exception();
        }
    }

    public void clearBatch() throws SQLException {
        this.stmt.clearBatch();
    }

    public void addBatch(String string) throws SQLException {
        this.stmt.addBatch(string);
    }

    public boolean commitBatch() throws SQLException {
        int[] nArray = this.stmt.executeBatch();
        return nArray.length >= 0;
    }
}

