/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.utility.error;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UserException
extends Exception {
    private int errorCatalog = 0;
    private int errorNo = 0;
    private String errorMessage = "";
    private String errorModule = "";
    private String errorAppend = "";
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static TreeMap userExceptionTreeMap = null;
    private static final String delimiter = "^";
    private static boolean isInited = false;

    private PrintStream getLogFile() {
        String string = System.getProperty("System.log.file");
        Calendar calendar = Calendar.getInstance();
        if (string != null) {
            string = string + "." + (calendar.get(2) + 1) + calendar.get(5);
            try {
                return new PrintStream(new FileOutputStream(string, true), true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isInited() {
        return isInited;
    }

    public UserException(int n, int n2, String string) {
        this.errorCatalog = n;
        this.errorNo = n2;
        this.errorModule = string;
        this.setErrorMessageFromErrorCode();
    }

    public UserException(int n, int n2, String string, String string2, String string3) {
        this.errorCatalog = n;
        this.errorNo = n2;
        this.errorModule = string;
        this.errorMessage = string2;
        this.errorAppend = string3;
    }

    public UserException(int n, int n2, String string, String string2) {
        this.errorCatalog = n;
        this.errorNo = n2;
        this.errorModule = string;
        this.errorMessage = string2;
    }

    public int getErrorCatalog() {
        return this.errorCatalog;
    }

    public int getErrorNo() {
        return this.errorNo;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorModule() {
        return this.errorModule;
    }

    private void setErrorMessageFromErrorCode() {
        if (this.errorMessage == null || this.errorMessage.trim().length() == 0) {
            this.errorMessage = (String)userExceptionTreeMap.get(this.errorCatalog + delimiter + this.errorNo);
            if (this.errorMessage == null) {
                this.errorMessage = "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            Calendar calendar = Calendar.getInstance();
            String string = LINE_SEPARATOR + "***** UserException occurred at " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13) + " *****" + LINE_SEPARATOR + "ErrorCatalog = " + this.getErrorCatalog() + LINE_SEPARATOR + "ErrorNo      = " + this.getErrorNo() + LINE_SEPARATOR + "ErrorModule  = " + this.getErrorModule() + LINE_SEPARATOR + "ErrorMessage = " + this.getErrorMessage() + LINE_SEPARATOR + LINE_SEPARATOR + "The stack trace is: " + LINE_SEPARATOR + this.errorAppend + LINE_SEPARATOR;
            printStream.print(string);
            super.printStackTrace(printStream);
            PrintStream printStream3 = this.getLogFile();
            if (printStream3 != null) {
                printStream3.print(string);
                printStream3.flush();
                super.printStackTrace(printStream3);
            }
        }
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public static synchronized void init(String string, boolean bl) throws Exception {
        if (bl || !isInited) {
            UserException.init(string);
        }
    }

    public static synchronized void init(String string) throws Exception {
        userExceptionTreeMap = new TreeMap();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(string));
        NodeList nodeList = document.getElementsByTagName("UserException");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            String string2 = nodeList.item(i).getAttributes().getNamedItem("ErrorCatalog").getNodeValue();
            String string3 = "";
            String string4 = "";
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (nodeList2.item(j).getNodeType() != 1) continue;
                Element element = (Element)nodeList2.item(j);
                string3 = element.getElementsByTagName("ErrorNo").item(0).getFirstChild().getNodeValue();
                string4 = element.getElementsByTagName("ErrorMessage").item(0).getFirstChild().getNodeValue();
                userExceptionTreeMap.put(string2 + delimiter + string3, string4);
            }
        }
        isInited = true;
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("System.log.file");
        Calendar calendar = Calendar.getInstance();
        if (string != null) {
            string = string + "." + (calendar.get(2) + 1) + calendar.get(5);
        }
        try {
            throw new UserException(100, 200, "Unkown Module", "Unkonw Error message--Only for test", "");
        }
        catch (UserException userException) {
            try {
                if (string != null) {
                    userException.printStackTrace(new PrintStream(new FileOutputStream(string, true), true));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }
}

