/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.utility.log;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.util.Date;

public final class Log {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static String syslogFile = null;
    private static String exceptionFile = null;
    private static boolean isInited = false;

    public static boolean isInited() {
        return isInited;
    }

    public static synchronized void init(String string, String string2, boolean bl) throws Exception {
        if (bl || !isInited) {
            Log.init(string, string2);
        }
    }

    private static synchronized void init(String string, String string2) throws Exception {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        randomAccessFile.close();
        randomAccessFile = new RandomAccessFile(string2, "rw");
        randomAccessFile.close();
        syslogFile = string;
        exceptionFile = string2;
        isInited = true;
    }

    public static void setSyslogFile(String string) {
        syslogFile = string;
    }

    public static void setExceptionFile(String string) {
        exceptionFile = string;
    }

    public static String getSyslogFile() {
        return syslogFile;
    }

    public static String getExceptionFile() {
        return exceptionFile;
    }

    public static synchronized void writeFile(String string, String string2) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        randomAccessFile.setLength(0L);
        randomAccessFile.writeBytes(string2);
        randomAccessFile.close();
    }

    private static synchronized int print(String string) {
        if (syslogFile == null) {
            System.out.println("***** Please set syslogFile before write syslog! *****");
            return -1;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(syslogFile, "rw");
            randomAccessFile.seek(randomAccessFile.length());
            randomAccessFile.writeBytes(string);
            randomAccessFile.close();
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
    }

    public static int print(int n) {
        return Log.print("" + n);
    }

    public static int print(double d) {
        return Log.print("" + d);
    }

    public static int print(Object object) {
        return Log.print(object.toString());
    }

    public static int println(String string) {
        return Log.print(string + LINE_SEPARATOR);
    }

    public static int println(int n) {
        return Log.print("" + n + LINE_SEPARATOR);
    }

    public static int println(double d) {
        return Log.print("" + d + LINE_SEPARATOR);
    }

    public static int println(Object object) {
        return Log.print(object.toString() + LINE_SEPARATOR);
    }

    private static synchronized int printException(String string) {
        String string2 = LINE_SEPARATOR + "[" + new Date() + "]" + LINE_SEPARATOR + string;
        if (exceptionFile == null) {
            System.out.println("***** Please set exceptionFile before write exception log! *****");
            return -1;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(exceptionFile, "rw");
            randomAccessFile.seek(randomAccessFile.length());
            randomAccessFile.writeBytes(string2);
            randomAccessFile.close();
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
    }

    public static int printException(int n) {
        return Log.printException("" + n);
    }

    public static int printException(double d) {
        return Log.printException("" + d);
    }

    public static int printException(Object object) {
        return Log.printException(object.toString());
    }

    public static int printException(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return Log.printException(stringWriter.toString());
    }

    public static void main(String[] stringArray) {
        Log.setExceptionFile("exception.log");
        Log.printException("Hello");
        Log.print("why");
    }
}

