/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.utility.string;

import java.util.Calendar;

public class Date {
    private String dateDelimiter = "";
    private static String TIME_DELIMITER = ":";
    private int year;
    private int month;
    private int date;
    private int hour;
    private int minute;
    private int second;
    public static int YEAR = 32;
    public static int MONTH = 16;
    public static int DATE = 8;
    public static int HOUR = 4;
    public static int MINUTE = 2;
    public static int SECOND = 1;

    public Date() {
        this.year = Calendar.getInstance().get(1);
        this.month = Calendar.getInstance().get(2) + 1;
        this.date = Calendar.getInstance().get(5);
        this.hour = Calendar.getInstance().get(11);
        this.minute = Calendar.getInstance().get(12);
        this.second = Calendar.getInstance().get(13);
        this.dateDelimiter = "/";
    }

    public Date(int n, int n2, int n3, int n4, int n5, int n6) {
        this.year = n;
        this.month = n2;
        this.date = n3;
        this.hour = n4;
        this.minute = n5;
        this.second = n6;
        this.dateDelimiter = "/";
    }

    public Date(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0);
    }

    public Date(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0, 0);
    }

    public Date(String string) {
        this.parse(string);
        if (this.dateDelimiter.equals("/")) {
            this.dateDelimiter = "";
        }
    }

    private void parse(Calendar calendar) {
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.date = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        if (this.dateDelimiter.equals("")) {
            this.dateDelimiter = "/";
        }
    }

    private void parse(String string) {
        String string2 = string;
        if (this.dateDelimiter.equals("")) {
            this.dateDelimiter = string2.indexOf("/") > -1 ? "/" : "-";
        }
        int n = 0;
        n = string2.indexOf(this.dateDelimiter);
        this.year = Integer.parseInt(string2.substring(0, n));
        string2 = string2.substring(n + 1);
        n = string2.indexOf(this.dateDelimiter);
        this.month = Integer.parseInt(string2.substring(0, n));
        if ((n = (string2 = string2.substring(n + 1)).indexOf(" ")) > -1) {
            this.date = Integer.parseInt(string2.substring(0, n));
            string2 = string2.substring(n + 1);
        } else {
            this.date = Integer.parseInt(string2);
            string2 = "";
        }
        n = string2.indexOf(TIME_DELIMITER);
        if (n > -1) {
            this.hour = Integer.parseInt(string2.substring(0, n));
            string2 = string2.substring(n + 1);
        } else {
            this.hour = 0;
            string2 = "";
        }
        n = string2.indexOf(TIME_DELIMITER);
        if (n > -1) {
            this.minute = Integer.parseInt(string2.substring(0, n));
            string2 = string2.substring(n + 1);
        } else {
            this.minute = 0;
            string2 = "";
        }
        this.second = !string2.trim().equals("") ? Integer.parseInt(string2) : 0;
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.year, this.month - 1, this.date, this.hour, this.minute, this.second);
        this.parse(calendar);
    }

    public String toString() {
        String string = "";
        string = this.year + this.dateDelimiter + this.month + this.dateDelimiter + this.date + " " + this.hour + TIME_DELIMITER + this.minute + TIME_DELIMITER + this.second;
        return string;
    }

    public void setDateDelimiter(String string) {
        this.dateDelimiter = string;
    }

    public String getDateDelimiter() {
        return this.dateDelimiter;
    }

    public int get(int n) {
        int n2 = -1;
        if (n == YEAR) {
            n2 = this.year;
        } else if (n == MONTH) {
            n2 = this.month;
        } else if (n == DATE) {
            n2 = this.date;
        } else if (n == HOUR) {
            n2 = this.hour;
        } else if (n == MINUTE) {
            n2 = this.minute;
        } else if (n == SECOND) {
            n2 = this.second;
        }
        return n2;
    }

    public void set(int n, int n2) {
        if (n == YEAR) {
            this.year = n2;
        } else if (n == MONTH) {
            this.month = n2;
        } else if (n == DATE) {
            this.date = n2;
        } else if (n == HOUR) {
            this.hour = n2;
        } else if (n == MINUTE) {
            this.minute = n2;
        } else if (n == SECOND) {
            this.second = n2;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.year, this.month - 1, this.date, this.hour, this.minute, this.second);
        this.parse(calendar);
    }

    public String getString(int n) {
        String string = "";
        if (n / YEAR > 0) {
            n %= YEAR;
            string = string + this.year;
        }
        if (n / MONTH > 0) {
            n %= MONTH;
            string = string.length() > 0 ? string + this.dateDelimiter + this.month : string + this.month;
        }
        if (n / DATE > 0) {
            n %= DATE;
            string = string.length() > 0 ? string + this.dateDelimiter + this.date : string + this.date;
        }
        if (n / HOUR > 0) {
            n %= HOUR;
            string = string.length() > 0 ? string + " " + this.hour : string + this.hour;
        }
        if (n / MINUTE > 0) {
            n %= MINUTE;
            string = string.length() > 0 ? string + TIME_DELIMITER + this.minute : string + this.minute;
        }
        if (n / SECOND > 0) {
            n %= SECOND;
            string = string.length() > 0 ? string + TIME_DELIMITER + this.second : string + this.second;
        }
        return string;
    }

    public java.util.Date toUtilDate() {
        return new java.util.Date(this.year - 1900, this.month - 1, this.date, this.hour, this.minute, this.second);
    }

    public long compareTo(Date date) {
        return this.toUtilDate().getTime() - date.toUtilDate().getTime();
    }

    public static void main(String[] stringArray) {
        Date date = new Date(stringArray[0]);
        Date date2 = new Date(stringArray[1]);
        java.util.Date date3 = date.toUtilDate();
        System.out.println(date3.toString());
        System.out.println(date3.getTime());
        java.util.Date date4 = new java.util.Date();
        date4 = new java.util.Date(date4.getYear(), date4.getMonth(), date4.getDate());
        System.out.println("compare: " + date3.compareTo(date4));
        System.out.println(date.compareTo(date2));
    }
}

