/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.utility.string;

import java.text.DecimalFormat;

public class Money {
    private static final String DOLLARS = "DOLLARS";
    private static final String DOLLAR = "DOLLAR";
    private static final String CENTS = "CENTS";
    private static final String CENT = "CENT";
    private static final String BILLION = "BILLION";
    private static final String MILLION = "MILLION";
    private static final String THOUSOND = "THOUSAND";
    private static final String HUNDRED = "HUNDRED";
    private static final String ZERO = "ZERO";
    private static final String ONLY = "ONLY";
    private static final int ONE_BILLION = 1000000000;
    private static final int ONE_MILLION = 1000000;
    private static final int ONE_THOUSOND = 1000;

    public static String toUpper(int n) throws IllegalArgumentException {
        String[] stringArray = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        if (n > 9) {
            throw new IllegalArgumentException("\u91d1\u989d\u8d85\u51fa\u8303\u56f4");
        }
        if (n < 0) {
            throw new IllegalArgumentException("\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f");
        }
        return stringArray[n];
    }

    public static String getUnit(int n) throws IllegalArgumentException {
        String[] stringArray = new String[]{"\u4edf", "\u4f70", "\u62fe", "\u4ebf", "\u4edf", "\u4f70", "\u62fe", "\u4e07", "\u4edf", "\u4f70", "\u62fe", "\u5143", "\u89d2", "\u5206"};
        if (n > 14) {
            throw new IllegalArgumentException("\u91d1\u989d\u8d85\u51fa\u8303\u56f4");
        }
        if (n < 0) {
            throw new IllegalArgumentException("\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f");
        }
        return stringArray[n];
    }

    public static String toEUpper(int n) throws IllegalArgumentException {
        String[] stringArray = new String[]{ZERO, "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE", "TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN", "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINETY"};
        if (n > 27 || n < 0) {
            throw new IllegalArgumentException("Array index overflow!");
        }
        return stringArray[n];
    }

    public static String toChinese(double d) throws IllegalArgumentException {
        String string = "";
        String string2 = "";
        String string3 = "                 ";
        String string4 = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (d < 0.0) {
            throw new IllegalArgumentException("\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f");
        }
        string2 = new DecimalFormat("0").format(d * 100.0);
        n3 = string2.length();
        if (n3 > 14) {
            throw new IllegalArgumentException("\u91d1\u989d\u8d85\u51fa\u8303\u56f4");
        }
        string2 = string3.substring(0, 14 - n3) + string2;
        for (n = 14 - n3; n < 14; ++n) {
            n2 = new Integer(string2.substring(n, n + 1));
            if (n2 > 0) {
                string = string + string4 + Money.toUpper(n2) + Money.getUnit(n);
                string4 = "";
                continue;
            }
            if (n == 11) {
                string = string + Money.getUnit(n);
            }
            if (n == 7 && !string2.substring(4, 8).equals("0000")) {
                string = string + Money.getUnit(n);
            }
            if (n == 3 && !string2.substring(0, 4).equals("0000")) {
                string = string + Money.getUnit(n);
            }
            if (n < 11) {
                string4 = Money.toUpper(0);
            }
            if (n != 12) continue;
            string4 = Money.toUpper(0);
        }
        if (string.endsWith("\u5143")) {
            string = string + "\u6574";
        }
        return string;
    }

    public static String toChinese(int n) throws IllegalArgumentException {
        return Money.toChinese((double)n);
    }

    public static String toChinese(long l) throws IllegalArgumentException {
        return Money.toChinese((double)l);
    }

    private static double getInt(double d, int n) throws IllegalArgumentException {
        String string = "";
        int n2 = 0;
        string = new DecimalFormat("0.00").format(d);
        n2 = string.indexOf(".");
        string = string.substring(0, n2 - n);
        return Double.parseDouble(string);
    }

    private static double getDecimal(double d, int n) throws IllegalArgumentException {
        String string = "";
        int n2 = 0;
        string = new DecimalFormat("0.00").format(d);
        n2 = string.indexOf(".");
        string = string.substring(n2 - n);
        return Double.parseDouble(string);
    }

    private static String format_99(int n) throws IllegalArgumentException {
        String string = "";
        int n2 = 0;
        int n3 = 0;
        if (n > 0 && n < 100) {
            if (n <= 20) {
                string = Money.toEUpper(n);
            } else {
                n3 = new Double(n / 10).intValue();
                string = Money.toEUpper(n3 + 18);
                n2 = n - 10 * n3;
                if (n2 != 0) {
                    string = string + " " + Money.toEUpper(n2);
                }
            }
        } else {
            string = "";
        }
        return string;
    }

    private static String format_999(double d) throws IllegalArgumentException {
        String string = "";
        int n = 0;
        int n2 = 0;
        if (d >= 0.0 && d < 1000.0) {
            n = new Double(d / 100.0).intValue();
            n2 = new Double(d).intValue() % 100;
            string = Money.format_99(n2);
            if (n != 0) {
                if (string.length() > 0 && !string.substring(0, 1).equals(" ")) {
                    string = " AND " + string;
                }
                string = Money.toEUpper(n) + " " + HUNDRED + string;
            }
        } else {
            string = "";
        }
        return string;
    }

    private static String formatToEnglish(double d) throws IllegalArgumentException {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (d < 0.0) {
            string2 = Money.formatToEnglish(-d);
            string2 = "minus " + string2;
        }
        if (d < 1.0) {
            string2 = ZERO;
        }
        if (d >= 1.0E9) {
            string2 = Money.formatToEnglish(Money.getInt(d, 9));
            string3 = Money.formatToEnglish(Money.getDecimal(d, 9));
            if (!string3.equals(ZERO)) {
                string3 = " " + string3;
            }
            string2 = string3.indexOf(MILLION) > -1 ? string2 + " " + BILLION + string3 : string2 + " " + BILLION + " AND " + string3;
        } else if (d >= 1000000.0 && d < 1.0E9) {
            string2 = Money.format_999(Money.getInt(d, 6));
            string3 = Money.formatToEnglish(Money.getDecimal(d, 6));
            if (!string3.equals(ZERO)) {
                string3 = " " + string3;
            }
            string2 = string3.indexOf(THOUSOND) > -1 ? string2 + " " + MILLION + string3 : string2 + " " + MILLION + " AND " + string3;
        } else if (d >= 1000.0 && d < 1000000.0) {
            string2 = Money.format_999(Money.getInt(d, 3));
            string3 = Money.formatToEnglish(Money.getDecimal(d, 3));
            if (!string3.equals(ZERO)) {
                string3 = " " + string3;
            }
            string2 = string3.indexOf(HUNDRED) > -1 ? string2 + " " + THOUSOND + string3 : string2 + " " + THOUSOND + " AND " + string3;
        } else if (d >= 1.0 && d < 1000.0) {
            string2 = Money.format_999(d);
        }
        return string2;
    }

    public static String toEnglish(double d) throws IllegalArgumentException {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        double d2 = 0.0;
        int n = 0;
        if (d < 0.0) {
            throw new IllegalArgumentException("Money can not be negative!");
        }
        string2 = new DecimalFormat("0").format(d * 100.0);
        n = string2.length();
        if (n > 14) {
            throw new IllegalArgumentException("Money exceeds its range(fourteen digits)!");
        }
        if (d == 0.0) {
            string = ZERO;
        }
        string3 = DOLLARS;
        string4 = CENTS;
        string = Money.formatToEnglish(Money.getInt(d, 0));
        string5 = Money.formatToEnglish(Money.getDecimal(d, -1));
        if (string.equals(Money.toEUpper(1))) {
            string3 = DOLLAR;
        }
        if (string5.equals(Money.toEUpper(1))) {
            string4 = CENT;
        }
        if (!string5.equals(ZERO)) {
            string = string.equals(ZERO) ? string5 + " " + string4 : string + " AND " + string4 + " " + string5;
        }
        string = string + " ONLY";
        return string;
    }

    public static String toEnglish(int n) throws IllegalArgumentException {
        return Money.toEnglish((double)n);
    }

    public static String toEnglish(long l) throws IllegalArgumentException {
        return Money.toEnglish((double)l);
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Money.toEnglish(0));
            System.out.println(Money.toEnglish(2.11));
            System.out.println(Money.toEnglish(12.1));
            System.out.println(Money.toEnglish(1.0000000100102E11));
            System.out.println(Money.toEnglish(1.0000100000102E11));
            System.out.println(Money.toEnglish(1.0000000000102E11));
            System.out.println(Money.toEnglish(46927.58));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("exception \u91d1\u989d\u8d85\u51fa\u8303\u56f4");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

