/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.spring.remoting;

import java.lang.reflect.Modifier;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.annotations.AnnotationServiceFactory;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.invoker.BeanInvoker;
import org.codehaus.xfire.service.invoker.Invoker;
import org.codehaus.xfire.spring.SpringUtils;
import org.codehaus.xfire.spring.remoting.XFireServletControllerAdapter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public class Jsr181HandlerMapping
extends AbstractUrlHandlerMapping {
    private WebAnnotations webAnnotations;
    private XFire xFire;
    private TypeMappingRegistry typeMappingRegistry;
    private String urlPrefix = "/services/";
    private String servletControllerAdapterName;

    protected void initApplicationContext() throws BeansException {
        AegisBindingProvider provider = this.typeMappingRegistry == null ? new AegisBindingProvider() : new AegisBindingProvider(this.typeMappingRegistry);
        AnnotationServiceFactory serviceFactory = new AnnotationServiceFactory(this.webAnnotations, this.xFire.getTransportManager(), (BindingProvider)provider);
        for (ApplicationContext context = this.getApplicationContext(); context != null; context = context.getParent()) {
            this.processBeans(context, serviceFactory);
        }
    }

    private void processBeans(ApplicationContext beanFactory, AnnotationServiceFactory serviceFactory) {
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        ConfigurableApplicationContext ctxt = (ConfigurableApplicationContext)beanFactory;
        for (int i = 0; i < beanNames.length; ++i) {
            Object bean;
            Class<?> clazz;
            BeanDefinition def = ctxt.getBeanFactory().getBeanDefinition(beanNames[i]);
            if (!def.isSingleton() || def.isAbstract()) continue;
            try {
                clazz = this.getApplicationContext().getType(beanNames[i]);
                bean = beanFactory.getBean(beanNames[i]);
                try {
                    clazz = SpringUtils.getUserTarget(bean).getClass();
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to get the User Target Class of bean " + beanNames[i]), (Throwable)e);
                }
            }
            catch (BeanIsAbstractException e) {
                continue;
            }
            if (clazz != null && !Modifier.isAbstract(clazz.getModifiers()) && this.webAnnotations.hasWebServiceAnnotation(clazz)) {
                Service endpoint = serviceFactory.create(clazz);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Exposing  service " + endpoint.getName() + " to " + this.urlPrefix + endpoint.getSimpleName()));
                }
                this.xFire.getServiceRegistry().register(endpoint);
                endpoint.setInvoker((Invoker)new BeanInvoker(bean));
                Object controller = this.createController(endpoint.getName());
                this.registerHandler(this.urlPrefix + endpoint.getSimpleName(), controller);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Rejected bean '" + beanNames[i] + "' since it has no WebService annotation"));
        }
    }

    private Object createController(QName endpointName) {
        if (this.servletControllerAdapterName != null) {
            Object controller = this.getApplicationContext().getBean(this.servletControllerAdapterName);
            if (controller == null) {
                this.logger.error((Object)("Failed to find bean with name " + this.servletControllerAdapterName));
            } else {
                try {
                    XFireServletControllerAdapter xFireServletControllerAdapter = (XFireServletControllerAdapter)((Object)SpringUtils.getUserTarget(controller));
                    xFireServletControllerAdapter.setServiceName(endpointName);
                    return controller;
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to create a Controller for endpoint " + endpointName), (Throwable)e);
                }
            }
        }
        return new XFireServletControllerAdapter(this.xFire, endpointName);
    }

    public void setWebAnnotations(WebAnnotations webAnnotations) {
        this.webAnnotations = webAnnotations;
    }

    public void setXfire(XFire xFire) {
        this.xFire = xFire;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public void setServletControllerAdapterName(String servletControllerAdapterName) {
        this.servletControllerAdapterName = servletControllerAdapterName;
    }
}

