/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.extensions.CancelExtendedRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class IdentifyUniqueAttributeConflicts
extends LDAPCommandLineTool
implements SearchResultListener {
    private static final String BEHAVIOR_UNIQUE_WITHIN_ATTR = "unique-within-each-attribute";
    private static final String BEHAVIOR_UNIQUE_ACROSS_ATTRS_INCLUDING_SAME = "unique-across-all-attributes-including-in-same-entry";
    private static final String BEHAVIOR_UNIQUE_ACROSS_ATTRS_EXCEPT_SAME = "unique-across-all-attributes-except-in-same-entry";
    private static final int DEFAULT_TIME_LIMIT_SECONDS = 10;
    private static final long serialVersionUID = -8298131659655985916L;
    private final AtomicBoolean timeLimitExceeded = new AtomicBoolean(false);
    private final AtomicLong entriesExamined = new AtomicLong(0L);
    private boolean allowConflictsInSameEntry = false;
    private boolean uniqueAcrossAttributes = false;
    private DNArgument baseDNArgument = null;
    private FilterArgument filterArgument = null;
    private IntegerArgument pageSizeArgument = null;
    private IntegerArgument timeLimitArgument = null;
    private LDAPConnectionPool findConflictsPool = null;
    private final Map<String, AtomicLong> conflictCounts = new TreeMap<String, AtomicLong>();
    private String[] attributes = null;
    private String[] baseDNs = null;
    private StringArgument attributeArgument = null;
    private StringArgument multipleAttributeBehaviorArgument = null;

    public static void main(String ... args) {
        ResultCode resultCode = IdentifyUniqueAttributeConflicts.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        IdentifyUniqueAttributeConflicts tool = new IdentifyUniqueAttributeConflicts(outStream, errStream);
        return tool.runTool(args);
    }

    public IdentifyUniqueAttributeConflicts(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "identify-unique-attribute-conflicts";
    }

    @Override
    public String getToolDescription() {
        return "This tool may be used to identify unique attribute conflicts.  That is, it may identify values of one or more attributes which are supposed to exist only in a single entry but are found in multiple entries.";
    }

    @Override
    public String getToolVersion() {
        return "3.2.1";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        String description = "The search base DN(s) to use to find entries with attributes for which to find uniqueness conflicts.  At least one base DN must be specified.";
        this.baseDNArgument = new DNArgument(Character.valueOf('b'), "baseDN", true, 0, "{dn}", description);
        this.baseDNArgument.addLongIdentifier("base-dn");
        parser.addArgument(this.baseDNArgument);
        description = "A filter that will be used to identify the set of entries in which to identify uniqueness conflicts.  If this is not specified, then all entries containing the target attribute(s) will be examined.";
        this.filterArgument = new FilterArgument(Character.valueOf('f'), "filter", false, 1, "{filter}", description);
        parser.addArgument(this.filterArgument);
        description = "The attributes for which to find uniqueness conflicts.  At least one attribute must be specified, and each attribute must be indexed for equality searches.";
        this.attributeArgument = new StringArgument(Character.valueOf('A'), "attribute", true, 0, "{attr}", description);
        parser.addArgument(this.attributeArgument);
        description = "Indicates the behavior to exhibit if multiple unique attributes are provided.  Allowed values are 'unique-within-each-attribute' (indicates that each value only needs to be unique within its own attribute type), 'unique-across-all-attributes-including-in-same-entry' (indicates that each value needs to be unique across all of the specified attributes), and 'unique-across-all-attributes-except-in-same-entry' (indicates each value needs to be unique across all of the specified attributes, except that multiple attributes in the same entry are allowed to share the same value).";
        LinkedHashSet<String> allowedValues = new LinkedHashSet<String>(3);
        allowedValues.add(BEHAVIOR_UNIQUE_WITHIN_ATTR);
        allowedValues.add(BEHAVIOR_UNIQUE_ACROSS_ATTRS_INCLUDING_SAME);
        allowedValues.add(BEHAVIOR_UNIQUE_ACROSS_ATTRS_EXCEPT_SAME);
        this.multipleAttributeBehaviorArgument = new StringArgument(Character.valueOf('m'), "multipleAttributeBehavior", false, 1, "{behavior}", description, allowedValues, BEHAVIOR_UNIQUE_WITHIN_ATTR);
        this.multipleAttributeBehaviorArgument.addLongIdentifier("multiple-attribute-behavior");
        parser.addArgument(this.multipleAttributeBehaviorArgument);
        description = "The maximum number of entries to retrieve at a time when attempting to find uniqueness conflicts.  This requires that the authenticated user have permission to use the simple paged results control, but it can avoid problems with the server sending entries too quickly for the client to handle.  By default, the simple paged results control will not be used.";
        this.pageSizeArgument = new IntegerArgument(Character.valueOf('z'), "simplePageSize", false, 1, "{num}", description, 1, Integer.MAX_VALUE);
        this.pageSizeArgument.addLongIdentifier("simple-page-size");
        parser.addArgument(this.pageSizeArgument);
        description = "The time limit in seconds that will be used for search requests attempting to identify conflicts for each value of any of the unique attributes.  This time limit is used to avoid sending expensive unindexed search requests that can consume significant server resources.  If any of these search operations fails in a way that indicates the requested time limit was exceeded, the tool will abort its processing.  A value of zero indicates that no time limit will be enforced.  If this argument is not provided, a default time limit of 10 will be used.";
        this.timeLimitArgument = new IntegerArgument(Character.valueOf('l'), "timeLimitSeconds", false, 1, "{num}", description, 0, Integer.MAX_VALUE, 10);
        this.timeLimitArgument.addLongIdentifier("timeLimit");
        this.timeLimitArgument.addLongIdentifier("time-limit-seconds");
        this.timeLimitArgument.addLongIdentifier("time-limit");
        parser.addArgument(this.timeLimitArgument);
    }

    @Override
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setUseSynchronousMode(true);
        options.setResponseTimeoutMillis(0L);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultCode doToolProcessing() {
        ResultCode resultCode;
        LDAPConnectionPool findUniqueAttributesPool;
        block33: {
            block32: {
                block31: {
                    List<String> attrList;
                    block30: {
                        block34: {
                            attrList = this.attributeArgument.getValues();
                            String multiAttrBehavior = this.multipleAttributeBehaviorArgument.getValue();
                            if (attrList.size() <= 1) break block34;
                            if (multiAttrBehavior.equalsIgnoreCase(BEHAVIOR_UNIQUE_ACROSS_ATTRS_INCLUDING_SAME)) {
                                this.uniqueAcrossAttributes = true;
                                this.allowConflictsInSameEntry = false;
                                break block30;
                            } else if (multiAttrBehavior.equalsIgnoreCase(BEHAVIOR_UNIQUE_ACROSS_ATTRS_EXCEPT_SAME)) {
                                this.uniqueAcrossAttributes = true;
                                this.allowConflictsInSameEntry = true;
                                break block30;
                            } else {
                                this.uniqueAcrossAttributes = false;
                                this.allowConflictsInSameEntry = true;
                            }
                            break block30;
                        }
                        this.uniqueAcrossAttributes = false;
                        this.allowConflictsInSameEntry = true;
                    }
                    List<DN> dnList = this.baseDNArgument.getValues();
                    this.baseDNs = new String[dnList.size()];
                    for (int i = 0; i < this.baseDNs.length; ++i) {
                        this.baseDNs[i] = dnList.get(i).toString();
                    }
                    try {
                        findUniqueAttributesPool = this.getConnectionPool(1, 1);
                        findUniqueAttributesPool.setRetryFailedOperationsDueToInvalidConnections(true);
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.err("Unable to establish a connection to the directory server:  ", StaticUtils.getExceptionMessage(le));
                        return le.getResultCode();
                    }
                    try {
                        Filter filter;
                        try {
                            this.findConflictsPool = this.getConnectionPool(1, 1);
                            this.findConflictsPool.setRetryFailedOperationsDueToInvalidConnections(true);
                        }
                        catch (LDAPException le) {
                            Debug.debugException(le);
                            this.err("Unable to establish a connection to the directory server:  ", StaticUtils.getExceptionMessage(le));
                            ResultCode resultCode2 = le.getResultCode();
                            Object var17_12 = null;
                            findUniqueAttributesPool.close();
                            if (this.findConflictsPool == null) return resultCode2;
                            this.findConflictsPool.close();
                            return resultCode2;
                        }
                        this.attributes = new String[attrList.size()];
                        attrList.toArray(this.attributes);
                        if (this.attributes.length == 1) {
                            filter = Filter.createPresenceFilter(this.attributes[0]);
                            this.conflictCounts.put(this.attributes[0], new AtomicLong(0L));
                        } else {
                            Filter[] orComps = new Filter[this.attributes.length];
                            for (int i = 0; i < this.attributes.length; ++i) {
                                orComps[i] = Filter.createPresenceFilter(this.attributes[i]);
                                this.conflictCounts.put(this.attributes[i], new AtomicLong(0L));
                            }
                            filter = Filter.createORFilter(orComps);
                        }
                        if (this.filterArgument.isPresent()) {
                            filter = Filter.createANDFilter(this.filterArgument.getValue(), filter);
                        }
                        for (String baseDN : this.baseDNs) {
                            ASN1OctetString cookie = null;
                            while (!this.timeLimitExceeded.get()) {
                                SimplePagedResultsControl pagedResultsResponse;
                                SearchResult searchResult;
                                SearchRequest searchRequest = new SearchRequest((SearchResultListener)this, baseDN, SearchScope.SUB, filter, this.attributes);
                                if (this.pageSizeArgument.isPresent()) {
                                    searchRequest.addControl(new SimplePagedResultsControl(this.pageSizeArgument.getValue(), cookie, false));
                                }
                                try {
                                    searchResult = findUniqueAttributesPool.search(searchRequest);
                                }
                                catch (LDAPSearchException lse) {
                                    Debug.debugException(lse);
                                    try {
                                        searchResult = this.findConflictsPool.search(searchRequest);
                                    }
                                    catch (LDAPSearchException lse2) {
                                        Debug.debugException(lse2);
                                        searchResult = lse2.getSearchResult();
                                    }
                                }
                                if (searchResult.getResultCode() != ResultCode.SUCCESS) {
                                    this.err("An error occurred while attempting to search for unique attributes in entries below " + baseDN + ":  " + searchResult.getDiagnosticMessage());
                                    ResultCode lse = searchResult.getResultCode();
                                    Object var17_13 = null;
                                    findUniqueAttributesPool.close();
                                    if (this.findConflictsPool == null) return lse;
                                    this.findConflictsPool.close();
                                    return lse;
                                }
                                try {
                                    pagedResultsResponse = SimplePagedResultsControl.get(searchResult);
                                }
                                catch (LDAPException le) {
                                    Debug.debugException(le);
                                    this.err("An error occurred while attempting to decode a simple paged results response control in the response to a search for entries below " + baseDN + ":  " + StaticUtils.getExceptionMessage(le));
                                    ResultCode resultCode3 = le.getResultCode();
                                    Object var17_14 = null;
                                    findUniqueAttributesPool.close();
                                    if (this.findConflictsPool == null) return resultCode3;
                                    this.findConflictsPool.close();
                                    return resultCode3;
                                }
                                if (pagedResultsResponse != null) {
                                    cookie = pagedResultsResponse.moreResultsToReturn() ? pagedResultsResponse.getCookie() : null;
                                }
                                if (cookie != null) continue;
                            }
                        }
                        boolean conflictFound = false;
                        for (Map.Entry<String, AtomicLong> e : this.conflictCounts.entrySet()) {
                            long numConflicts = e.getValue().get();
                            if (numConflicts <= 0L) continue;
                            if (!conflictFound) {
                                this.err(new Object[0]);
                                conflictFound = true;
                            }
                            this.err("Found " + numConflicts + " unique value conflicts in attribute " + e.getKey());
                        }
                        if (conflictFound) {
                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                            break block31;
                        }
                        if (this.timeLimitExceeded.get()) {
                            resultCode = ResultCode.TIME_LIMIT_EXCEEDED;
                            break block32;
                        }
                        this.out("No unique attribute conflicts were found.");
                        resultCode = ResultCode.SUCCESS;
                        break block33;
                    }
                    catch (Throwable throwable) {
                        Object var17_18 = null;
                        findUniqueAttributesPool.close();
                        if (this.findConflictsPool == null) throw throwable;
                        this.findConflictsPool.close();
                        throw throwable;
                    }
                }
                Object var17_15 = null;
                findUniqueAttributesPool.close();
                if (this.findConflictsPool == null) return resultCode;
                this.findConflictsPool.close();
                return resultCode;
            }
            Object var17_16 = null;
            findUniqueAttributesPool.close();
            if (this.findConflictsPool == null) return resultCode;
            this.findConflictsPool.close();
            return resultCode;
        }
        Object var17_17 = null;
        findUniqueAttributesPool.close();
        if (this.findConflictsPool == null) return resultCode;
        this.findConflictsPool.close();
        return resultCode;
    }

    public Map<String, AtomicLong> getConflictCounts() {
        return Collections.unmodifiableMap(this.conflictCounts);
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleMap = new LinkedHashMap<String[], String>(1);
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=john.doe,ou=People,dc=example,dc=com", "--bindPassword", "password", "--baseDN", "dc=example,dc=com", "--attribute", "uid", "--simplePageSize", "100"};
        exampleMap.put(args, "Identify any values of the uid attribute that are not unique across all entries below dc=example,dc=com.");
        return exampleMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void searchEntryReturned(SearchResultEntry searchEntry) {
        block33: {
            block30: {
                block31: {
                    block34: {
                        if (this.timeLimitExceeded.get()) {
                            return;
                        }
                        try {
                            if (this.allowConflictsInSameEntry) ** GOTO lbl18
                            conflictFound = false;
                            i = 0;
lbl7:
                            // 2 sources

                            while (true) {
                                if (i < this.attributes.length) {
                                    l1 = searchEntry.getAttributesWithOptions(this.attributes[i], null);
                                    if (l1 == null) break block30;
                                    break block31;
                                }
                                if (conflictFound) {
                                    var24_19 = null;
                                    count = this.entriesExamined.incrementAndGet();
                                    if (count % 1000L != 0L) return;
                                    break;
                                }
lbl18:
                                // 4 sources

                                block11: for (String attrName : this.attributes) {
                                    attrList = searchEntry.getAttributesWithOptions(attrName, null);
                                    i$ = attrList.iterator();
                                    while (true) {
                                        if (!i$.hasNext()) continue block11;
                                        a = i$.next();
                                        arr$ = a.getValues();
                                        len$ = arr$.length;
                                        i$ = 0;
                                        break block33;
                                        break;
                                    }
                                }
                                break block34;
                                break;
                            }
                        }
                        catch (Throwable var23_38) {
                            var24_22 = null;
                            count = this.entriesExamined.incrementAndGet();
                            if (count % 1000L != 0L) throw var23_38;
                            this.out(new Object[]{count, " entries examined"});
                            throw var23_38;
                        }
                        this.out(new Object[]{count, " entries examined"});
                        return;
                    }
                    var24_21 = null;
                    count = this.entriesExamined.incrementAndGet();
                    if (count % 1000L != 0L) return;
                    this.out(new Object[]{count, " entries examined"});
                    return;
                }
                for (j = i + 1; j < this.attributes.length; ++j) {
                    l2 = searchEntry.getAttributesWithOptions(this.attributes[j], null);
                    if (l2 == null) continue;
                    for (Attribute a1 : l1) {
                        for (String value : a1.getValues()) {
                            for (Attribute a2 : l2) {
                                if (!a2.hasValue(value)) continue;
                                this.err(new Object[]{"Value '", value, "' in attribute ", a1.getName(), " of entry '", searchEntry.getDN(), " is also present in attribute ", a2.getName(), " of the same entry."});
                                conflictFound = true;
                                this.conflictCounts.get(this.attributes[i]).incrementAndGet();
                            }
                        }
                    }
                }
            }
            ++i;
            ** while (true)
        }
        while (true) {
            if (i$ >= len$) ** continue;
            value = arr$[i$];
            if (this.uniqueAcrossAttributes) {
                orComps = new Filter[this.attributes.length];
                for (i = 0; i < this.attributes.length; ++i) {
                    orComps[i] = Filter.createEqualityFilter(this.attributes[i], value);
                }
                filter = Filter.createORFilter(orComps);
            } else {
                filter = Filter.createEqualityFilter(attrName, value);
            }
            if (this.filterArgument.isPresent()) {
                filter = Filter.createANDFilter(new Filter[]{this.filterArgument.getValue(), filter});
            }
            block19: for (String baseDN : this.baseDNs) {
                searchRequest = new SearchRequest(baseDN, SearchScope.SUB, DereferencePolicy.NEVER, 2, (int)this.timeLimitArgument.getValue(), false, filter, new String[]{"1.1"});
                try {
                    searchResult = this.findConflictsPool.search(searchRequest);
                }
                catch (LDAPSearchException lse) {
                    Debug.debugException(lse);
                    if (lse.getResultCode() == ResultCode.TIME_LIMIT_EXCEEDED) {
                        this.timeLimitExceeded.set(true);
                        try {
                            this.findConflictsPool.processExtendedOperation(new CancelExtendedRequest(searchEntry.getMessageID()));
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                        this.err(new Object[]{"A server-side time limit was exceeded when searching below base DN '" + baseDN + "' with filter '" + filter + "', which likely means that the search " + "request is not indexed in the server.  Check the " + "server configuration to ensure that any appropriate " + "indexes are in place.  To indicate that searches " + "should not request any time limit, use the " + this.timeLimitArgument.getIdentifierString() + " to indicate a time limit of zero seconds."});
                        var24_20 = null;
                        count = this.entriesExamined.incrementAndGet();
                        if (count % 1000L != 0L) return;
                        this.out(new Object[]{count, " entries examined"});
                        return;
                    }
                    if (lse.getResultCode().isConnectionUsable()) {
                        searchResult = lse.getSearchResult();
                    }
                    try {
                        searchResult = this.findConflictsPool.search(searchRequest);
                    }
                    catch (LDAPSearchException lse2) {
                        Debug.debugException(lse2);
                        searchResult = lse2.getSearchResult();
                    }
                }
                for (SearchResultEntry e : searchResult.getSearchEntries()) {
                    try {
                        if (DN.equals(searchEntry.getDN(), e.getDN())) {
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        Debug.debugException(ex);
                    }
                    this.err(new Object[]{"Value '", value, "' in attribute ", a.getName(), " of entry '" + searchEntry.getDN(), "' is also present in entry '", e.getDN(), "'."});
                    this.conflictCounts.get(attrName).incrementAndGet();
                    break block19;
                }
                if (searchResult.getResultCode() == ResultCode.SUCCESS) continue;
                this.err(new Object[]{"An error occurred while attempting to search for conflicts with " + a.getName() + " value '" + value + "' (as found in entry '" + searchEntry.getDN() + "') below '" + baseDN + "':  " + searchResult.getDiagnosticMessage()});
                this.conflictCounts.get(attrName).incrementAndGet();
                break;
            }
            ++i$;
        }
    }

    @Override
    public void searchReferenceReturned(SearchResultReference searchReference) {
    }
}

