/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataLogCaptureWindow;
import com.unboundid.ldap.sdk.unboundidds.tasks.CollectSupportDataSecurityLevel;
import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class CollectSupportDataExtendedRequestProperties
implements Serializable {
    private static final long serialVersionUID = 5585016444537427389L;
    private ASN1OctetString encryptionPassphrase;
    private Boolean includeBinaryFiles;
    private Boolean includeExpensiveData;
    private Boolean includeExtensionSource;
    private Boolean includeReplicationStateDump;
    private Boolean useSequentialMode;
    private CollectSupportDataLogCaptureWindow logCaptureWindow;
    private CollectSupportDataSecurityLevel securityLevel;
    private Integer jstackCount;
    private Integer maximumFragmentSizeBytes;
    private Integer proxyToServerPort;
    private Integer reportCount;
    private Integer reportIntervalSeconds;
    private String archiveFileName;
    private String comment;
    private String proxyToServerAddress;

    public CollectSupportDataExtendedRequestProperties() {
        this.encryptionPassphrase = null;
        this.includeBinaryFiles = null;
        this.includeExpensiveData = null;
        this.includeExtensionSource = null;
        this.includeReplicationStateDump = null;
        this.useSequentialMode = null;
        this.logCaptureWindow = null;
        this.securityLevel = null;
        this.jstackCount = null;
        this.maximumFragmentSizeBytes = null;
        this.proxyToServerPort = null;
        this.reportCount = null;
        this.reportIntervalSeconds = null;
        this.archiveFileName = null;
        this.comment = null;
        this.proxyToServerAddress = null;
    }

    public CollectSupportDataExtendedRequestProperties(CollectSupportDataExtendedRequestProperties properties) {
        this.encryptionPassphrase = properties.getEncryptionPassphrase();
        this.includeBinaryFiles = properties.getIncludeBinaryFiles();
        this.includeExpensiveData = properties.getIncludeExpensiveData();
        this.includeExtensionSource = properties.getIncludeExtensionSource();
        this.includeReplicationStateDump = properties.getIncludeReplicationStateDump();
        this.useSequentialMode = properties.getUseSequentialMode();
        this.logCaptureWindow = properties.getLogCaptureWindow();
        this.securityLevel = properties.getSecurityLevel();
        this.jstackCount = properties.getJStackCount();
        this.maximumFragmentSizeBytes = properties.getMaximumFragmentSizeBytes();
        this.proxyToServerPort = properties.getProxyToServerPort();
        this.reportCount = properties.getReportCount();
        this.reportIntervalSeconds = properties.getReportIntervalSeconds();
        this.archiveFileName = properties.getArchiveFileName();
        this.comment = properties.getComment();
        this.proxyToServerAddress = properties.getProxyToServerAddress();
    }

    public CollectSupportDataExtendedRequestProperties(CollectSupportDataExtendedRequest request) {
        this.encryptionPassphrase = request.getEncryptionPassphrase();
        this.includeBinaryFiles = request.getIncludeBinaryFiles();
        this.includeExpensiveData = request.getIncludeExpensiveData();
        this.includeExtensionSource = request.getIncludeExtensionSource();
        this.includeReplicationStateDump = request.getIncludeReplicationStateDump();
        this.useSequentialMode = request.getUseSequentialMode();
        this.logCaptureWindow = request.getLogCaptureWindow();
        this.securityLevel = request.getSecurityLevel();
        this.jstackCount = request.getJStackCount();
        this.maximumFragmentSizeBytes = request.getMaximumFragmentSizeBytes();
        this.proxyToServerPort = request.getProxyToServerPort();
        this.reportCount = request.getReportCount();
        this.reportIntervalSeconds = request.getReportIntervalSeconds();
        this.archiveFileName = request.getArchiveFileName();
        this.comment = request.getComment();
        this.proxyToServerAddress = request.getProxyToServerAddress();
    }

    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public void setArchiveFileName(String archiveFileName) {
        this.archiveFileName = archiveFileName;
    }

    public ASN1OctetString getEncryptionPassphrase() {
        return this.encryptionPassphrase;
    }

    public void setEncryptionPassphrase(String encryptionPassphrase) {
        this.encryptionPassphrase = encryptionPassphrase == null ? null : new ASN1OctetString(-127, encryptionPassphrase);
    }

    public void setEncryptionPassphrase(byte[] encryptionPassphrase) {
        this.encryptionPassphrase = encryptionPassphrase == null ? null : new ASN1OctetString(-127, encryptionPassphrase);
    }

    public void setEncryptionPassphrase(ASN1OctetString encryptionPassphrase) {
        this.encryptionPassphrase = encryptionPassphrase == null ? null : new ASN1OctetString(-127, encryptionPassphrase.getValue());
    }

    public Boolean getIncludeExpensiveData() {
        return this.includeExpensiveData;
    }

    public void setIncludeExpensiveData(Boolean includeExpensiveData) {
        this.includeExpensiveData = includeExpensiveData;
    }

    public Boolean getIncludeReplicationStateDump() {
        return this.includeReplicationStateDump;
    }

    public void setIncludeReplicationStateDump(Boolean includeReplicationStateDump) {
        this.includeReplicationStateDump = includeReplicationStateDump;
    }

    public Boolean getIncludeBinaryFiles() {
        return this.includeBinaryFiles;
    }

    public void setIncludeBinaryFiles(Boolean includeBinaryFiles) {
        this.includeBinaryFiles = includeBinaryFiles;
    }

    public Boolean getIncludeExtensionSource() {
        return this.includeExtensionSource;
    }

    public void setIncludeExtensionSource(Boolean includeExtensionSource) {
        this.includeExtensionSource = includeExtensionSource;
    }

    public Boolean getUseSequentialMode() {
        return this.useSequentialMode;
    }

    public void setUseSequentialMode(Boolean useSequentialMode) {
        this.useSequentialMode = useSequentialMode;
    }

    public CollectSupportDataSecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(CollectSupportDataSecurityLevel securityLevel) {
        this.securityLevel = securityLevel;
    }

    public Integer getJStackCount() {
        return this.jstackCount;
    }

    public void setJStackCount(Integer jstackCount) {
        if (jstackCount != null) {
            Validator.ensureTrue(jstackCount >= 0, "If CollectSupportDataExtendedRequestProperties.jstackCount is non-null, then the value must be greater than or equal to zero.");
        }
        this.jstackCount = jstackCount;
    }

    public Integer getReportCount() {
        return this.reportCount;
    }

    public void setReportCount(Integer reportCount) {
        if (reportCount != null) {
            Validator.ensureTrue(reportCount >= 0, "If CollectSupportDataExtendedRequestProperties.reportCount is non-null, then the value must be greater than or equal to zero.");
        }
        this.reportCount = reportCount;
    }

    public Integer getReportIntervalSeconds() {
        return this.reportIntervalSeconds;
    }

    public void setReportIntervalSeconds(Integer reportIntervalSeconds) {
        if (reportIntervalSeconds != null) {
            Validator.ensureTrue(reportIntervalSeconds > 0, "If CollectSupportDataExtendedRequestProperties.reportIntervalSeconds is non-null, then the value must be greater than zero.");
        }
        this.reportIntervalSeconds = reportIntervalSeconds;
    }

    public CollectSupportDataLogCaptureWindow getLogCaptureWindow() {
        return this.logCaptureWindow;
    }

    public void setLogCaptureWindow(CollectSupportDataLogCaptureWindow logCaptureWindow) {
        this.logCaptureWindow = logCaptureWindow;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getProxyToServerAddress() {
        return this.proxyToServerAddress;
    }

    public Integer getProxyToServerPort() {
        return this.proxyToServerPort;
    }

    public void setProxyToServer(String address, Integer port) {
        if (address == null) {
            Validator.ensureTrue(port == null, "If CollectSupportDataExtendedRequestProperties.proxyToServer.address is null, then CollectSupportDataExtendedRequestProperties.proxyToServer.port must also be null.");
        } else {
            Validator.ensureFalse(address.isEmpty(), "If CollectSupportDataExtendedRequestProperties.proxyToServer.address is non-null, then it must also be non-empty.");
            Validator.ensureNotNullWithMessage(port, "If CollectSupportDataExtendedRequestProperties.proxyToServer.address is non-null, then CollectSupportDataExtendedRequestProperties.proxyToServer.port must also be non-null.");
            Validator.ensureTrue(port >= 1 && port <= 65535, "If CollectSupportDataExtendedRequestProperties.proxyToServer.port is non-null, then its value must be between 1 and 65535, inclusive.");
        }
        this.proxyToServerAddress = address;
        this.proxyToServerPort = port;
    }

    public Integer getMaximumFragmentSizeBytes() {
        return this.maximumFragmentSizeBytes;
    }

    public void setMaximumFragmentSizeBytes(Integer maximumFragmentSizeBytes) {
        if (maximumFragmentSizeBytes != null) {
            Validator.ensureTrue(maximumFragmentSizeBytes > 0, "If CollectSupportDataExtendedRequestProperties.maximumFragmentSizeBytes is non-null, then its value must be greater than zero.");
        }
        this.maximumFragmentSizeBytes = maximumFragmentSizeBytes;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("CollectSupportDataArchiveProperties(");
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "archiveFileName", this.archiveFileName);
        if (this.encryptionPassphrase != null) {
            CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "encryptionPassphrase", "*****REDACTED*****");
        }
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "includeExpensiveData", this.includeExpensiveData);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "includeReplicationStateDump", this.includeReplicationStateDump);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "includeBinaryFiles", this.includeBinaryFiles);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "includeExtensionSource", this.includeExtensionSource);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "securityLevel", (Object)this.securityLevel);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "useSequentialMode", this.useSequentialMode);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "jstackCount", this.jstackCount);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "reportCount", this.reportCount);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "reportIntervalSeconds", this.reportIntervalSeconds);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "logCaptureWindow", this.logCaptureWindow);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "comment", this.comment);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "proxyToServerAddress", this.proxyToServerAddress);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "proxyToServerPort", this.proxyToServerPort);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "maximumFragmentSizeBytes", this.maximumFragmentSizeBytes);
        buffer.append(')');
    }

    private static void appendNameValuePair(StringBuilder buffer, String name, Object value) {
        if (value == null) {
            return;
        }
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '(') {
            buffer.append(", ");
        }
        buffer.append(name);
        buffer.append('=');
        if (value instanceof Boolean || value instanceof Integer || value instanceof CollectSupportDataLogCaptureWindow) {
            buffer.append(value);
        } else {
            buffer.append('\'');
            buffer.append(value);
            buffer.append('\'');
        }
    }
}

