/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CollectSupportDataExtendedResult
extends ExtendedResult {
    public static final String COLLECT_SUPPORT_DATA_RESULT_OID = "1.3.6.1.4.1.30221.2.6.67";
    private static final byte TYPE_EXIT_CODE = -128;
    private static final long serialVersionUID = 9005943853349941187L;
    private final Integer exitCode;

    public CollectSupportDataExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, Integer exitCode, Control ... controls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, exitCode == null ? null : COLLECT_SUPPORT_DATA_RESULT_OID, CollectSupportDataExtendedResult.encodeValue(exitCode), controls);
        this.exitCode = exitCode;
    }

    private static ASN1OctetString encodeValue(Integer exitCode) {
        if (exitCode == null) {
            return null;
        }
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1Integer(-128, exitCode));
        return new ASN1OctetString(valueSequence.encode());
    }

    public CollectSupportDataExtendedResult(ExtendedResult extendedResult) throws LDAPException {
        super(extendedResult);
        ASN1OctetString value = extendedResult.getValue();
        if (value == null) {
            this.exitCode = null;
            return;
        }
        try {
            ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(value.getValue());
            ASN1Element[] elements = valueSequence.elements();
            this.exitCode = ASN1Integer.decodeAsInteger(elements[0]).intValue();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CSD_RESULT_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    @Override
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_COLLECT_SUPPORT_DATA_RESULT_NAME.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("CollectSupportDataExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if (this.exitCode != null) {
            buffer.append(", exitCode=");
            buffer.append(this.exitCode);
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

