/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Null;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataLogCaptureWindow;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ToolDefaultCollectSupportDataLogCaptureWindow
extends CollectSupportDataLogCaptureWindow {
    private static final ToolDefaultCollectSupportDataLogCaptureWindow INSTANCE = new ToolDefaultCollectSupportDataLogCaptureWindow();
    private static final long serialVersionUID = 7186806291464509659L;
    private final ASN1Element encodedWindow = new ASN1Null(-128);

    private ToolDefaultCollectSupportDataLogCaptureWindow() {
    }

    public static ToolDefaultCollectSupportDataLogCaptureWindow getInstance() {
        return INSTANCE;
    }

    static ToolDefaultCollectSupportDataLogCaptureWindow decodeInternal(ASN1Element e) throws LDAPException {
        try {
            ASN1Null.decodeAsNull(e);
        }
        catch (Exception ex) {
            Debug.debugException(ex);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_TOOL_DEFAULT_CSD_LOG_WINDOW_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(ex)), ex);
        }
        return INSTANCE;
    }

    @Override
    public ASN1Element encode() {
        return this.encodedWindow;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ToolDefaultCollectSupportDataLogCaptureWindow()");
    }
}

