/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.embeddings;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Embedding
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Embedding.class);
    @NonNull
    private String model;
    @NonNull
    private List<String> input;
    private String user;
    @JsonProperty(value="encoding_format")
    private String encodingFormat;

    public void setModel(Model model) {
        if (Objects.isNull((Object)model)) {
            model = Model.TEXT_EMBEDDING_ADA_002;
        }
        this.model = model.getName();
    }

    public void setUser(String user) {
        this.user = user;
    }

    private static String $default$model() {
        return Model.TEXT_EMBEDDING_ADA_002.getName();
    }

    public static EmbeddingBuilder builder() {
        return new EmbeddingBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public List<String> getInput() {
        return this.input;
    }

    public String getUser() {
        return this.user;
    }

    public String getEncodingFormat() {
        return this.encodingFormat;
    }

    public Embedding() {
        this.model = Embedding.$default$model();
    }

    public Embedding(@NonNull String model, @NonNull List<String> input, String user, String encodingFormat) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.model = model;
        this.input = input;
        this.user = user;
        this.encodingFormat = encodingFormat;
    }

    public static class EmbeddingBuilder {
        private boolean model$set;
        private String model$value;
        private List<String> input;
        private String user;
        private String encodingFormat;

        EmbeddingBuilder() {
        }

        public EmbeddingBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public EmbeddingBuilder input(@NonNull List<String> input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        public EmbeddingBuilder user(String user) {
            this.user = user;
            return this;
        }

        @JsonProperty(value="encoding_format")
        public EmbeddingBuilder encodingFormat(String encodingFormat) {
            this.encodingFormat = encodingFormat;
            return this;
        }

        public Embedding build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = Embedding.$default$model();
            }
            return new Embedding(model$value, this.input, this.user, this.encodingFormat);
        }

        public String toString() {
            return "Embedding.EmbeddingBuilder(model$value=" + this.model$value + ", input=" + this.input + ", user=" + this.user + ", encodingFormat=" + this.encodingFormat + ")";
        }
    }

    public static enum EncodingFormat {
        FLOAT("float"),
        BASE64("base64");

        private final String name;

        public String getName() {
            return this.name;
        }

        private EncodingFormat(String name) {
            this.name = name;
        }
    }

    public static enum Model {
        TEXT_EMBEDDING_ADA_002("text-embedding-ada-002");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Model(String name) {
            this.name = name;
        }
    }
}

